/*
 * Decompiled with CFR 0.152.
 */
package com.buildstash;

import com.buildstash.BuildstashBuildAction;
import com.buildstash.BuildstashStep;
import com.buildstash.BuildstashUploadHelper;
import com.buildstash.BuildstashUploadRequest;
import com.buildstash.BuildstashUploadResponse;
import com.buildstash.BuildstashUploadService;
import com.buildstash.VersionControlDetector;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class BuildstashStepExecution
extends SynchronousNonBlockingStepExecution<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    private final BuildstashStep step;

    public BuildstashStepExecution(BuildstashStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    protected Map<String, Object> run() throws Exception {
        EnvVars env;
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        Run run = (Run)this.getContext().get(Run.class);
        EnvVars envFromContext = (EnvVars)this.getContext().get(EnvVars.class);
        if (listener == null) {
            throw new IllegalStateException("TaskListener not available");
        }
        try {
            env = run.getEnvironment(listener);
            if (envFromContext != null) {
                env.overrideAll((Map)envFromContext);
            }
        }
        catch (Exception e) {
            env = envFromContext != null ? envFromContext : new EnvVars();
        }
        Secret apiKeySecret = this.step.getApiKey();
        String apiKeyPlain = apiKeySecret != null ? Secret.toString((Secret)apiKeySecret) : null;
        String expandedApiKey = BuildstashUploadHelper.expand(env, apiKeyPlain);
        String expandedStructure = BuildstashUploadHelper.expand(env, this.step.getStructure());
        if (expandedStructure == null || expandedStructure.isBlank()) {
            expandedStructure = "file";
        }
        String expandedPrimaryFilePath = BuildstashUploadHelper.expand(env, this.step.getPrimaryFilePath());
        String expandedExpansionFilePath = BuildstashUploadHelper.expand(env, this.step.getExpansionFilePath());
        String expandedVersionComponent1Major = BuildstashUploadHelper.expand(env, this.step.getVersionComponent1Major());
        String expandedVersionComponent2Minor = BuildstashUploadHelper.expand(env, this.step.getVersionComponent2Minor());
        String expandedVersionComponent3Patch = BuildstashUploadHelper.expand(env, this.step.getVersionComponent3Patch());
        String expandedVersionComponentExtra = BuildstashUploadHelper.expand(env, this.step.getVersionComponentExtra());
        String expandedVersionComponentMeta = BuildstashUploadHelper.expand(env, this.step.getVersionComponentMeta());
        String expandedCustomBuildNumber = BuildstashUploadHelper.expand(env, this.step.getCustomBuildNumber());
        String expandedLabels = BuildstashUploadHelper.expand(env, this.step.getLabels());
        String expandedArchitectures = BuildstashUploadHelper.expand(env, this.step.getArchitectures());
        String expandedPlatform = BuildstashUploadHelper.expand(env, this.step.getPlatform());
        String expandedStream = BuildstashUploadHelper.expand(env, this.step.getStream());
        String expandedNotes = BuildstashUploadHelper.expand(env, this.step.getNotes());
        String expandedVcHostType = BuildstashUploadHelper.expand(env, this.step.getVcHostType());
        String expandedVcHost = BuildstashUploadHelper.expand(env, this.step.getVcHost());
        String expandedVcRepoName = BuildstashUploadHelper.expand(env, this.step.getVcRepoName());
        String expandedVcRepoUrl = BuildstashUploadHelper.expand(env, this.step.getVcRepoUrl());
        String expandedVcBranch = BuildstashUploadHelper.expand(env, this.step.getVcBranch());
        String expandedVcCommitSha = BuildstashUploadHelper.expand(env, this.step.getVcCommitSha());
        String expandedVcCommitUrl = BuildstashUploadHelper.expand(env, this.step.getVcCommitUrl());
        BuildstashUploadHelper.validateParameters(expandedApiKey, expandedPrimaryFilePath, expandedVersionComponent1Major, expandedVersionComponent2Minor, expandedVersionComponent3Patch, expandedPlatform, expandedStream);
        BuildstashUploadService uploadService = new BuildstashUploadService(expandedApiKey, listener);
        BuildstashUploadRequest request = BuildstashUploadHelper.createUploadRequest(workspace, run, expandedStructure, expandedPrimaryFilePath, expandedExpansionFilePath, expandedVersionComponent1Major, expandedVersionComponent2Minor, expandedVersionComponent3Patch, expandedVersionComponentExtra, expandedVersionComponentMeta, expandedCustomBuildNumber, expandedLabels, expandedArchitectures, expandedPlatform, expandedStream, expandedNotes, expandedVcHostType, expandedVcHost, expandedVcRepoName, expandedVcRepoUrl, expandedVcBranch, expandedVcCommitSha, expandedVcCommitUrl);
        VersionControlDetector.populateVersionControlInfo(run, request, listener);
        BuildstashUploadResponse response = uploadService.upload(request);
        BuildstashUploadHelper.logResults(listener, response);
        BuildstashBuildAction existingAction = (BuildstashBuildAction)run.getAction(BuildstashBuildAction.class);
        if (existingAction != null) {
            existingAction.addResponse(response);
        } else {
            run.addAction((Action)new BuildstashBuildAction(response));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("buildId", response.getBuildId());
        result.put("buildInfoUrl", response.getBuildInfoUrl());
        result.put("downloadUrl", response.getDownloadUrl());
        result.put("pendingProcessing", response.isPendingProcessing());
        result.put("message", response.getMessage());
        return result;
    }
}

