// CHECKSTYLE:OFF

package io.jenkins.plugins.credentials.secretsmanager;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code secretText}: {@code Secret Text}.
     * 
     * @return
     *     {@code Secret Text}
     */
    public static String secretText() {
        return holder.format("secretText");
    }

    /**
     * Key {@code secretText}: {@code Secret Text}.
     * 
     * @return
     *     {@code Secret Text}
     */
    public static Localizable _secretText() {
        return new Localizable(holder, "secretText");
    }

    /**
     * Key {@code awsSecretsManager}: {@code AWS Secrets Manager}.
     * 
     * @return
     *     {@code AWS Secrets Manager}
     */
    public static String awsSecretsManager() {
        return holder.format("awsSecretsManager");
    }

    /**
     * Key {@code awsSecretsManager}: {@code AWS Secrets Manager}.
     * 
     * @return
     *     {@code AWS Secrets Manager}
     */
    public static Localizable _awsSecretsManager() {
        return new Localizable(holder, "awsSecretsManager");
    }

    /**
     * Key {@code role}: {@code Role}.
     * 
     * @return
     *     {@code Role}
     */
    public static String role() {
        return holder.format("role");
    }

    /**
     * Key {@code role}: {@code Role}.
     * 
     * @return
     *     {@code Role}
     */
    public static Localizable _role() {
        return new Localizable(holder, "role");
    }

    /**
     * Key {@code cacheDurationTooLowUsingTheMinimumDurationInstead}: {@code
     * The specified cache duration of {0} seconds is too low. Using the
     * minimum cache duration of {1} seconds instead.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The specified cache duration of {0} seconds is too low. Using
     *     the minimum cache duration of {1} seconds instead.}
     */
    public static String cacheDurationTooLowUsingTheMinimumDurationInstead(Object arg0, Object arg1) {
        return holder.format("cacheDurationTooLowUsingTheMinimumDurationInstead", arg0, arg1);
    }

    /**
     * Key {@code cacheDurationTooLowUsingTheMinimumDurationInstead}: {@code
     * The specified cache duration of {0} seconds is too low. Using the
     * minimum cache duration of {1} seconds instead.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The specified cache duration of {0} seconds is too low. Using
     *     the minimum cache duration of {1} seconds instead.}
     */
    public static Localizable _cacheDurationTooLowUsingTheMinimumDurationInstead(Object arg0, Object arg1) {
        return new Localizable(holder, "cacheDurationTooLowUsingTheMinimumDurationInstead", arg0, arg1);
    }

    /**
     * Key {@code couldNotRetrieveCredentialError}: {@code Could not retrieve
     * the credential {0} from AWS Secrets Manager}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not retrieve the credential {0} from AWS Secrets Manager}
     */
    public static String couldNotRetrieveCredentialError(Object arg0) {
        return holder.format("couldNotRetrieveCredentialError", arg0);
    }

    /**
     * Key {@code couldNotRetrieveCredentialError}: {@code Could not retrieve
     * the credential {0} from AWS Secrets Manager}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Could not retrieve the credential {0} from AWS Secrets Manager}
     */
    public static Localizable _couldNotRetrieveCredentialError(Object arg0) {
        return new Localizable(holder, "couldNotRetrieveCredentialError", arg0);
    }

    /**
     * Key {@code prefix}: {@code Prefix}.
     * 
     * @return
     *     {@code Prefix}
     */
    public static String prefix() {
        return holder.format("prefix");
    }

    /**
     * Key {@code prefix}: {@code Prefix}.
     * 
     * @return
     *     {@code Prefix}
     */
    public static Localizable _prefix() {
        return new Localizable(holder, "prefix");
    }

    /**
     * Key {@code roles}: {@code Roles}.
     * 
     * @return
     *     {@code Roles}
     */
    public static String roles() {
        return holder.format("roles");
    }

    /**
     * Key {@code roles}: {@code Roles}.
     * 
     * @return
     *     {@code Roles}
     */
    public static Localizable _roles() {
        return new Localizable(holder, "roles");
    }

    /**
     * Key {@code certificate}: {@code Certificate}.
     * 
     * @return
     *     {@code Certificate}
     */
    public static String certificate() {
        return holder.format("certificate");
    }

    /**
     * Key {@code certificate}: {@code Certificate}.
     * 
     * @return
     *     {@code Certificate}
     */
    public static Localizable _certificate() {
        return new Localizable(holder, "certificate");
    }

    /**
     * Key {@code description}: {@code Description}.
     * 
     * @return
     *     {@code Description}
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Key {@code description}: {@code Description}.
     * 
     * @return
     *     {@code Description}
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

    /**
     * Key {@code awsSecretsManagerSecret}: {@code AWS Secrets Manager
     * secret}.
     * 
     * @return
     *     {@code AWS Secrets Manager secret}
     */
    public static String awsSecretsManagerSecret() {
        return holder.format("awsSecretsManagerSecret");
    }

    /**
     * Key {@code awsSecretsManagerSecret}: {@code AWS Secrets Manager
     * secret}.
     * 
     * @return
     *     {@code AWS Secrets Manager secret}
     */
    public static Localizable _awsSecretsManagerSecret() {
        return new Localizable(holder, "awsSecretsManagerSecret");
    }

    /**
     * Key {@code sshUserPrivateKey}: {@code SSH User Private Key}.
     * 
     * @return
     *     {@code SSH User Private Key}
     */
    public static String sshUserPrivateKey() {
        return holder.format("sshUserPrivateKey");
    }

    /**
     * Key {@code sshUserPrivateKey}: {@code SSH User Private Key}.
     * 
     * @return
     *     {@code SSH User Private Key}
     */
    public static Localizable _sshUserPrivateKey() {
        return new Localizable(holder, "sshUserPrivateKey");
    }

    /**
     * Key {@code awsServerError}: {@code AWS server error}.
     * 
     * @return
     *     {@code AWS server error}
     */
    public static String awsServerError() {
        return holder.format("awsServerError");
    }

    /**
     * Key {@code awsServerError}: {@code AWS server error}.
     * 
     * @return
     *     {@code AWS server error}
     */
    public static Localizable _awsServerError() {
        return new Localizable(holder, "awsServerError");
    }

    /**
     * Key {@code removePrefixes}: {@code Remove Prefixes}.
     * 
     * @return
     *     {@code Remove Prefixes}
     */
    public static String removePrefixes() {
        return holder.format("removePrefixes");
    }

    /**
     * Key {@code removePrefixes}: {@code Remove Prefixes}.
     * 
     * @return
     *     {@code Remove Prefixes}
     */
    public static Localizable _removePrefixes() {
        return new Localizable(holder, "removePrefixes");
    }

    /**
     * Key {@code listSecrets}: {@code ListSecrets}.
     * 
     * @return
     *     {@code ListSecrets}
     */
    public static String listSecrets() {
        return holder.format("listSecrets");
    }

    /**
     * Key {@code listSecrets}: {@code ListSecrets}.
     * 
     * @return
     *     {@code ListSecrets}
     */
    public static Localizable _listSecrets() {
        return new Localizable(holder, "listSecrets");
    }

    /**
     * Key {@code file}: {@code Secret File}.
     * 
     * @return
     *     {@code Secret File}
     */
    public static String file() {
        return holder.format("file");
    }

    /**
     * Key {@code file}: {@code Secret File}.
     * 
     * @return
     *     {@code Secret File}
     */
    public static Localizable _file() {
        return new Localizable(holder, "file");
    }

    /**
     * Key {@code emptySecretError}: {@code AWS Secrets Manager entry {0}
     * contained neither a secretString nor a secretBinary value}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code AWS Secrets Manager entry {0} contained neither a secretString
     *     nor a secretBinary value}
     */
    public static String emptySecretError(Object arg0) {
        return holder.format("emptySecretError", arg0);
    }

    /**
     * Key {@code emptySecretError}: {@code AWS Secrets Manager entry {0}
     * contained neither a secretString nor a secretBinary value}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code AWS Secrets Manager entry {0} contained neither a secretString
     *     nor a secretBinary value}
     */
    public static Localizable _emptySecretError(Object arg0) {
        return new Localizable(holder, "emptySecretError", arg0);
    }

    /**
     * Key {@code removePrefix}: {@code Remove Prefix}.
     * 
     * @return
     *     {@code Remove Prefix}
     */
    public static String removePrefix() {
        return holder.format("removePrefix");
    }

    /**
     * Key {@code removePrefix}: {@code Remove Prefix}.
     * 
     * @return
     *     {@code Remove Prefix}
     */
    public static Localizable _removePrefix() {
        return new Localizable(holder, "removePrefix");
    }

    /**
     * Key {@code client}: {@code Client}.
     * 
     * @return
     *     {@code Client}
     */
    public static String client() {
        return holder.format("client");
    }

    /**
     * Key {@code client}: {@code Client}.
     * 
     * @return
     *     {@code Client}
     */
    public static Localizable _client() {
        return new Localizable(holder, "client");
    }

    /**
     * Key {@code noUsernameError}: {@code Credential did not have a
     * username}.
     * 
     * @return
     *     {@code Credential did not have a username}
     */
    public static String noUsernameError() {
        return holder.format("noUsernameError");
    }

    /**
     * Key {@code noUsernameError}: {@code Credential did not have a
     * username}.
     * 
     * @return
     *     {@code Credential did not have a username}
     */
    public static Localizable _noUsernameError() {
        return new Localizable(holder, "noUsernameError");
    }

    /**
     * Key {@code tag}: {@code Tag}.
     * 
     * @return
     *     {@code Tag}
     */
    public static String tag() {
        return holder.format("tag");
    }

    /**
     * Key {@code tag}: {@code Tag}.
     * 
     * @return
     *     {@code Tag}
     */
    public static Localizable _tag() {
        return new Localizable(holder, "tag");
    }

    /**
     * Key {@code noCertificateError}: {@code Credential did not contain a
     * valid certificate bundle in PKCS#12 format}.
     * 
     * @return
     *     {@code Credential did not contain a valid certificate bundle in
     *     PKCS#12 format}
     */
    public static String noCertificateError() {
        return holder.format("noCertificateError");
    }

    /**
     * Key {@code noCertificateError}: {@code Credential did not contain a
     * valid certificate bundle in PKCS#12 format}.
     * 
     * @return
     *     {@code Credential did not contain a valid certificate bundle in
     *     PKCS#12 format}
     */
    public static Localizable _noCertificateError() {
        return new Localizable(holder, "noCertificateError");
    }

    /**
     * Key {@code arn}: {@code ARN}.
     * 
     * @return
     *     {@code ARN}
     */
    public static String arn() {
        return holder.format("arn");
    }

    /**
     * Key {@code arn}: {@code ARN}.
     * 
     * @return
     *     {@code ARN}
     */
    public static Localizable _arn() {
        return new Localizable(holder, "arn");
    }

    /**
     * Key {@code value}: {@code Value}.
     * 
     * @return
     *     {@code Value}
     */
    public static String value() {
        return holder.format("value");
    }

    /**
     * Key {@code value}: {@code Value}.
     * 
     * @return
     *     {@code Value}
     */
    public static Localizable _value() {
        return new Localizable(holder, "value");
    }

    /**
     * Key {@code awsClientError}: {@code AWS client error}.
     * 
     * @return
     *     {@code AWS client error}
     */
    public static String awsClientError() {
        return holder.format("awsClientError");
    }

    /**
     * Key {@code awsClientError}: {@code AWS client error}.
     * 
     * @return
     *     {@code AWS client error}
     */
    public static Localizable _awsClientError() {
        return new Localizable(holder, "awsClientError");
    }

    /**
     * Key {@code beta}: {@code Beta}.
     * 
     * @return
     *     {@code Beta}
     */
    public static String beta() {
        return holder.format("beta");
    }

    /**
     * Key {@code beta}: {@code Beta}.
     * 
     * @return
     *     {@code Beta}
     */
    public static Localizable _beta() {
        return new Localizable(holder, "beta");
    }

    /**
     * Key {@code authentication}: {@code Authentication}.
     * 
     * @return
     *     {@code Authentication}
     */
    public static String authentication() {
        return holder.format("authentication");
    }

    /**
     * Key {@code authentication}: {@code Authentication}.
     * 
     * @return
     *     {@code Authentication}
     */
    public static Localizable _authentication() {
        return new Localizable(holder, "authentication");
    }

    /**
     * Key {@code noPrivateKeyError}: {@code Credential did not contain a
     * valid private key in PEM format}.
     * 
     * @return
     *     {@code Credential did not contain a valid private key in PEM format}
     */
    public static String noPrivateKeyError() {
        return holder.format("noPrivateKeyError");
    }

    /**
     * Key {@code noPrivateKeyError}: {@code Credential did not contain a
     * valid private key in PEM format}.
     * 
     * @return
     *     {@code Credential did not contain a valid private key in PEM format}
     */
    public static Localizable _noPrivateKeyError() {
        return new Localizable(holder, "noPrivateKeyError");
    }

    /**
     * Key {@code invalidCacheDuration}: {@code Cache duration must be at
     * least {0} seconds}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cache duration must be at least {0} seconds}
     */
    public static String invalidCacheDuration(Object arg0) {
        return holder.format("invalidCacheDuration", arg0);
    }

    /**
     * Key {@code invalidCacheDuration}: {@code Cache duration must be at
     * least {0} seconds}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cache duration must be at least {0} seconds}
     */
    public static Localizable _invalidCacheDuration(Object arg0) {
        return new Localizable(holder, "invalidCacheDuration", arg0);
    }

    /**
     * Key {@code defaultClient}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String defaultClient() {
        return holder.format("defaultClient");
    }

    /**
     * Key {@code defaultClient}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _defaultClient() {
        return new Localizable(holder, "defaultClient");
    }

    /**
     * Key {@code profile}: {@code Profile}.
     * 
     * @return
     *     {@code Profile}
     */
    public static String profile() {
        return holder.format("profile");
    }

    /**
     * Key {@code profile}: {@code Profile}.
     * 
     * @return
     *     {@code Profile}
     */
    public static Localizable _profile() {
        return new Localizable(holder, "profile");
    }

    /**
     * Key {@code customClients}: {@code Custom}.
     * 
     * @return
     *     {@code Custom}
     */
    public static String customClients() {
        return holder.format("customClients");
    }

    /**
     * Key {@code customClients}: {@code Custom}.
     * 
     * @return
     *     {@code Custom}
     */
    public static Localizable _customClients() {
        return new Localizable(holder, "customClients");
    }

    /**
     * Key {@code assumeRole}: {@code STS AssumeRole}.
     * 
     * @return
     *     {@code STS AssumeRole}
     */
    public static String assumeRole() {
        return holder.format("assumeRole");
    }

    /**
     * Key {@code assumeRole}: {@code STS AssumeRole}.
     * 
     * @return
     *     {@code STS AssumeRole}
     */
    public static Localizable _assumeRole() {
        return new Localizable(holder, "assumeRole");
    }

    /**
     * Key {@code clientConfiguration}: {@code Client Configuration}.
     * 
     * @return
     *     {@code Client Configuration}
     */
    public static String clientConfiguration() {
        return holder.format("clientConfiguration");
    }

    /**
     * Key {@code clientConfiguration}: {@code Client Configuration}.
     * 
     * @return
     *     {@code Client Configuration}
     */
    public static Localizable _clientConfiguration() {
        return new Localizable(holder, "clientConfiguration");
    }

    /**
     * Key {@code filters}: {@code Filters}.
     * 
     * @return
     *     {@code Filters}
     */
    public static String filters() {
        return holder.format("filters");
    }

    /**
     * Key {@code filters}: {@code Filters}.
     * 
     * @return
     *     {@code Filters}
     */
    public static Localizable _filters() {
        return new Localizable(holder, "filters");
    }

    /**
     * Key {@code usernamePassword}: {@code Username With Password}.
     * 
     * @return
     *     {@code Username With Password}
     */
    public static String usernamePassword() {
        return holder.format("usernamePassword");
    }

    /**
     * Key {@code usernamePassword}: {@code Username With Password}.
     * 
     * @return
     *     {@code Username With Password}
     */
    public static Localizable _usernamePassword() {
        return new Localizable(holder, "usernamePassword");
    }

    /**
     * Key {@code tags}: {@code Tags}.
     * 
     * @return
     *     {@code Tags}
     */
    public static String tags() {
        return holder.format("tags");
    }

    /**
     * Key {@code tags}: {@code Tags}.
     * 
     * @return
     *     {@code Tags}
     */
    public static Localizable _tags() {
        return new Localizable(holder, "tags");
    }

    /**
     * Key {@code filter}: {@code Filter}.
     * 
     * @return
     *     {@code Filter}
     */
    public static String filter() {
        return holder.format("filter");
    }

    /**
     * Key {@code filter}: {@code Filter}.
     * 
     * @return
     *     {@code Filter}
     */
    public static Localizable _filter() {
        return new Localizable(holder, "filter");
    }

    /**
     * Key {@code deefault}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String deefault() {
        return holder.format("deefault");
    }

    /**
     * Key {@code deefault}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _deefault() {
        return new Localizable(holder, "deefault");
    }

    /**
     * Key {@code hide}: {@code Hide}.
     * 
     * @return
     *     {@code Hide}
     */
    public static String hide() {
        return holder.format("hide");
    }

    /**
     * Key {@code hide}: {@code Hide}.
     * 
     * @return
     *     {@code Hide}
     */
    public static Localizable _hide() {
        return new Localizable(holder, "hide");
    }

    /**
     * Key {@code failure}: {@code Failure}.
     * 
     * @return
     *     {@code Failure}
     */
    public static String failure() {
        return holder.format("failure");
    }

    /**
     * Key {@code failure}: {@code Failure}.
     * 
     * @return
     *     {@code Failure}
     */
    public static Localizable _failure() {
        return new Localizable(holder, "failure");
    }

    /**
     * Key {@code success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String success() {
        return holder.format("success");
    }

    /**
     * Key {@code success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _success() {
        return new Localizable(holder, "success");
    }

    /**
     * Key {@code transformations}: {@code Transformations}.
     * 
     * @return
     *     {@code Transformations}
     */
    public static String transformations() {
        return holder.format("transformations");
    }

    /**
     * Key {@code transformations}: {@code Transformations}.
     * 
     * @return
     *     {@code Transformations}
     */
    public static Localizable _transformations() {
        return new Localizable(holder, "transformations");
    }

    /**
     * Key {@code endpointConfiguration}: {@code Endpoint Configuration}.
     * 
     * @return
     *     {@code Endpoint Configuration}
     */
    public static String endpointConfiguration() {
        return holder.format("endpointConfiguration");
    }

    /**
     * Key {@code endpointConfiguration}: {@code Endpoint Configuration}.
     * 
     * @return
     *     {@code Endpoint Configuration}
     */
    public static Localizable _endpointConfiguration() {
        return new Localizable(holder, "endpointConfiguration");
    }

    /**
     * Key {@code statik}: {@code Static}.
     * 
     * @return
     *     {@code Static}
     */
    public static String statik() {
        return holder.format("statik");
    }

    /**
     * Key {@code statik}: {@code Static}.
     * 
     * @return
     *     {@code Static}
     */
    public static Localizable _statik() {
        return new Localizable(holder, "statik");
    }

    /**
     * Key {@code region}: {@code Region}.
     * 
     * @return
     *     {@code Region}
     */
    public static String region() {
        return holder.format("region");
    }

    /**
     * Key {@code region}: {@code Region}.
     * 
     * @return
     *     {@code Region}
     */
    public static Localizable _region() {
        return new Localizable(holder, "region");
    }

}
