/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.armorcode;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.armorcode.config.ArmorCodeGlobalConfig;
import io.jenkins.plugins.armorcode.credentials.CredentialsUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ArmorCodeReleaseGateBuilder
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(ArmorCodeReleaseGateBuilder.class.getName());
    private final String product;
    private final Object subProducts;
    private final String env;
    private int maxRetries = 5;
    private String mode = "block";
    private String targetUrl;
    private int retryDelay = 20;

    @DataBoundSetter
    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @DataBoundConstructor
    public ArmorCodeReleaseGateBuilder(String product, Object subProducts, String env) {
        this.product = product;
        this.subProducts = subProducts;
        this.env = env;
    }

    @DataBoundSetter
    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries > 0 ? maxRetries : 5;
    }

    @DataBoundSetter
    public void setMode(String mode) {
        this.mode = mode != null ? mode : "block";
    }

    public String getProduct() {
        return this.product;
    }

    public Object getSubProducts() {
        return this.subProducts;
    }

    public String getEnv() {
        return this.env;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getMode() {
        return this.mode;
    }

    public String getTargetUrl() {
        return this.targetUrl == null || this.targetUrl.isBlank() ? null : this.targetUrl;
    }

    @DataBoundSetter
    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    private String formatDetailedErrorMessage(Run<?, ?> run, JSONObject responseJson) throws UnsupportedEncodingException {
        Object reasonObj;
        JSONObject riskProperties;
        JSONObject severity;
        StringBuilder message = new StringBuilder();
        message.append("Group: ").append(this.product).append("\n");
        message.append("Sub Group: ").append(this.subProducts).append("\n");
        message.append("Environment: ").append(this.env).append("\n");
        StringBuilder findingsScope = new StringBuilder();
        boolean hasFindings = false;
        boolean isSeverityBased = false;
        boolean isRiskBased = false;
        if (responseJson.has("severity") && responseJson.optJSONObject("severity") != null) {
            severity = responseJson.getJSONObject("severity");
            if (severity.has("Critical") && severity.getInt("Critical") > 0 || severity.has("High") && severity.getInt("High") > 0 || severity.has("Medium") && severity.getInt("Medium") > 0 || severity.has("Low") && severity.getInt("Low") > 0) {
                isSeverityBased = true;
            }
        } else if (responseJson.has("severity.Critical") && responseJson.getInt("severity.Critical") > 0 || responseJson.has("severity.High") && responseJson.getInt("severity.High") > 0 || responseJson.has("severity.Medium") && responseJson.getInt("severity.Medium") > 0 || responseJson.has("severity.Low") && responseJson.getInt("severity.Low") > 0) {
            isSeverityBased = true;
        }
        if (responseJson.has("otherProperties") && responseJson.optJSONObject("otherProperties") != null) {
            riskProperties = responseJson.getJSONObject("otherProperties");
            if (riskProperties.has("VERY_POOR") && riskProperties.getInt("VERY_POOR") > 0 || riskProperties.has("POOR") && riskProperties.getInt("POOR") > 0 || riskProperties.has("FAIR") && riskProperties.getInt("FAIR") > 0 || riskProperties.has("GOOD") && riskProperties.getInt("GOOD") > 0) {
                isRiskBased = true;
            }
        } else if (responseJson.has("otherProperties.VERY_POOR") && responseJson.getInt("otherProperties.VERY_POOR") > 0 || responseJson.has("otherProperties.POOR") && responseJson.getInt("otherProperties.POOR") > 0 || responseJson.has("otherProperties.FAIR") && responseJson.getInt("otherProperties.FAIR") > 0 || responseJson.has("otherProperties.GOOD") && responseJson.getInt("otherProperties.GOOD") > 0) {
            isRiskBased = true;
        }
        if (isSeverityBased) {
            if (responseJson.has("severity") && responseJson.optJSONObject("severity") != null) {
                severity = responseJson.getJSONObject("severity");
                if (severity.has("Critical") && severity.getInt("Critical") > 0) {
                    findingsScope.append(severity.getInt("Critical")).append(" Critical, ");
                    hasFindings = true;
                }
                if (severity.has("High") && severity.getInt("High") > 0) {
                    findingsScope.append(severity.getInt("High")).append(" High, ");
                    hasFindings = true;
                }
                if (severity.has("Medium") && severity.getInt("Medium") > 0) {
                    findingsScope.append(severity.getInt("Medium")).append(" Medium, ");
                    hasFindings = true;
                }
                if (severity.has("Low") && severity.getInt("Low") > 0) {
                    findingsScope.append(severity.getInt("Low")).append(" Low");
                    hasFindings = true;
                }
            } else {
                if (responseJson.has("severity.Critical") && responseJson.getInt("severity.Critical") > 0) {
                    findingsScope.append(responseJson.getInt("severity.Critical")).append(" Critical, ");
                    hasFindings = true;
                }
                if (responseJson.has("severity.High") && responseJson.getInt("severity.High") > 0) {
                    findingsScope.append(responseJson.getInt("severity.High")).append(" High, ");
                    hasFindings = true;
                }
                if (responseJson.has("severity.Medium") && responseJson.getInt("severity.Medium") > 0) {
                    findingsScope.append(responseJson.getInt("severity.Medium")).append(" Medium, ");
                    hasFindings = true;
                }
                if (responseJson.has("severity.Low") && responseJson.getInt("severity.Low") > 0) {
                    findingsScope.append(responseJson.getInt("severity.Low")).append(" Low");
                    hasFindings = true;
                }
            }
        } else if (isRiskBased) {
            if (responseJson.has("otherProperties") && responseJson.optJSONObject("otherProperties") != null) {
                riskProperties = responseJson.getJSONObject("otherProperties");
                if (riskProperties.has("VERY_POOR") && riskProperties.getInt("VERY_POOR") > 0) {
                    findingsScope.append(riskProperties.getInt("VERY_POOR")).append(" Very Poor, ");
                    hasFindings = true;
                }
                if (riskProperties.has("POOR") && riskProperties.getInt("POOR") > 0) {
                    findingsScope.append(riskProperties.getInt("POOR")).append(" Poor, ");
                    hasFindings = true;
                }
                if (riskProperties.has("FAIR") && riskProperties.getInt("FAIR") > 0) {
                    findingsScope.append(riskProperties.getInt("FAIR")).append(" Fair, ");
                    hasFindings = true;
                }
                if (riskProperties.has("GOOD") && riskProperties.getInt("GOOD") > 0) {
                    findingsScope.append(riskProperties.getInt("GOOD")).append(" Good");
                    hasFindings = true;
                }
            } else {
                if (responseJson.has("otherProperties.VERY_POOR") && responseJson.getInt("otherProperties.VERY_POOR") > 0) {
                    findingsScope.append(responseJson.getInt("otherProperties.VERY_POOR")).append(" Very Poor, ");
                    hasFindings = true;
                }
                if (responseJson.has("otherProperties.POOR") && responseJson.getInt("otherProperties.POOR") > 0) {
                    findingsScope.append(responseJson.getInt("otherProperties.POOR")).append(" Poor, ");
                    hasFindings = true;
                }
                if (responseJson.has("otherProperties.FAIR") && responseJson.getInt("otherProperties.FAIR") > 0) {
                    findingsScope.append(responseJson.getInt("otherProperties.FAIR")).append(" Fair, ");
                    hasFindings = true;
                }
                if (responseJson.has("otherProperties.GOOD") && responseJson.getInt("otherProperties.GOOD") > 0) {
                    findingsScope.append(responseJson.getInt("otherProperties.GOOD")).append(" Good");
                    hasFindings = true;
                }
            }
        }
        String scopeString = findingsScope.toString();
        if (scopeString.endsWith(", ")) {
            scopeString = scopeString.substring(0, scopeString.length() - 2);
        }
        if (hasFindings) {
            message.append("Findings Scope: ").append(scopeString).append("\n");
        } else {
            message.append("Findings Scope: No findings detected\n");
        }
        String reason = "SLA check failed";
        if (responseJson.has("failureReasonText") && (reasonObj = responseJson.get("failureReasonText")) != null && !reasonObj.toString().equals("null") && !reasonObj.toString().isEmpty()) {
            reason = reasonObj.toString();
        }
        message.append("Reason: ").append(reason).append("\n");
        String buildNumber = String.valueOf(run.getNumber());
        String jobName = run.getParent().getFullName();
        String baseDetailsLink = responseJson.optString("detailsLink", responseJson.optString("link", "https://app.armorcode.com/client/integrations/jenkins"));
        String detailsLink = baseDetailsLink + (baseDetailsLink.contains("?") ? "&" : "?") + "filters=" + URLEncoder.encode("{\"buildNumber\":[\"" + buildNumber + "\"],\"jobName\":[\"" + jobName + "\"]}", StandardCharsets.UTF_8);
        message.append("For more details, please refer to: ").append(detailsLink);
        return message.toString();
    }

    private boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return ((String)value).isBlank();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        return value.toString().isBlank();
    }

    private void validateSecurityPrerequisites(Run<?, ?> run, TaskListener listener, String token) throws AbortException {
        if (this.isNullOrEmpty(this.product) || this.isNullOrEmpty(this.subProducts) || this.isNullOrEmpty(this.env)) {
            throw new AbortException("Incomplete security configuration");
        }
        if (this.isNullOrEmpty(token)) {
            throw new AbortException("Missing security authentication");
        }
    }

    private void saveGateInfoToProperties(Run<?, ?> run, String gateResult) {
        ArrayList<StringParameterValue> newParams = new ArrayList<StringParameterValue>();
        newParams.add(new StringParameterValue("ArmorCode.GateUsed", "true"));
        newParams.add(new StringParameterValue("ArmorCode.Product", this.product));
        newParams.add(new StringParameterValue("ArmorCode.SubProducts", this.subProducts.toString()));
        newParams.add(new StringParameterValue("ArmorCode.Env", this.env));
        newParams.add(new StringParameterValue("ArmorCode.GateResult", gateResult));
        ArrayList<String> safeParameterNames = new ArrayList<String>();
        safeParameterNames.add("ArmorCode.GateUsed");
        safeParameterNames.add("ArmorCode.Product");
        safeParameterNames.add("ArmorCode.SubProducts");
        safeParameterNames.add("ArmorCode.Env");
        safeParameterNames.add("ArmorCode.GateResult");
        run.addAction((Action)new ParametersAction(newParams, safeParameterNames));
    }

    private void handleFailureMode(Run<?, ?> run, TaskListener listener) throws AbortException {
        if ("block".equalsIgnoreCase(this.mode)) {
            listener.getLogger().println("[BLOCK] SLA check FAILED => Terminating build with failure.");
            run.setResult(Result.FAILURE);
            throw new AbortException("ArmorCode release gate failed: Security check did not pass");
        }
        if (!"warn".equalsIgnoreCase(this.mode)) {
            listener.getLogger().println("[BLOCK] Release gate is running in BLOCK mode => Terminating build with failure.");
            run.setResult(Result.FAILURE);
            throw new AbortException("ArmorCode release gate failed: Security check did not pass");
        }
        listener.getLogger().println("[WARN] SLA check FAILED but 'warn' mode is active => Marking build as UNSTABLE and continuing...");
        run.setResult(Result.UNSTABLE);
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, AbortException {
        Object finalUrl;
        String buildNumber = String.valueOf(run.getNumber());
        String jobName = run.getParent().getFullName();
        String apiBaseUrl = this.targetUrl;
        ArmorCodeGlobalConfig globalConfig = ArmorCodeGlobalConfig.get();
        if ((apiBaseUrl == null || apiBaseUrl.isBlank()) && globalConfig != null) {
            apiBaseUrl = globalConfig.getBaseUrl();
        }
        if (apiBaseUrl == null || apiBaseUrl.isBlank()) {
            apiBaseUrl = "https://app.armorcode.com";
        }
        if (!((String)(finalUrl = apiBaseUrl)).endsWith("/client/build")) {
            finalUrl = (String)finalUrl + "/client/build";
        }
        String token = CredentialsUtils.getArmorCodeToken(run);
        this.validateSecurityPrerequisites(run, listener, token);
        String jobUrl = "";
        try {
            jobUrl = run.getParent().getAbsoluteUrl();
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("[WARN] Could not determine Jenkins job URL. Please configure the Jenkins URL in the global configuration.");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error getting job URL", e);
        }
        listener.getLogger().println("=== Starting ArmorCode Release Gate Check ===");
        boolean failureHandled = false;
        for (int attempt = 1; attempt <= this.maxRetries; ++attempt) {
            try {
                String responseStr = this.postArmorCodeRequest(listener, token, buildNumber, jobName, attempt, this.maxRetries, (String)finalUrl, jobUrl);
                JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)responseStr);
                String status = json.optString("status", "UNKNOWN");
                listener.getLogger().println("=== ArmorCode Release Gate ===");
                listener.getLogger().println("Status: " + status);
                if (!"HOLD".equalsIgnoreCase(status)) {
                    if ("FAILED".equalsIgnoreCase(status)) {
                        String detailedError = this.formatDetailedErrorMessage(run, json);
                        listener.getLogger().println(detailedError);
                        this.saveGateInfoToProperties(run, "FAIL");
                        this.handleFailureMode(run, listener);
                        failureHandled = true;
                        if ("block".equalsIgnoreCase(this.mode)) {
                            return;
                        }
                        return;
                    }
                    listener.getLogger().println("[INFO] ArmorCode check passed! Proceeding...");
                    this.saveGateInfoToProperties(run, "PASS");
                    return;
                }
                listener.getLogger().println("[INFO] SLA is on HOLD. Sleeping " + this.retryDelay + "s...");
                listener.getLogger().println("[INFO] Sleeping " + this.retryDelay + " seconds before trying again. You can temporarily release the build from ArmorCode console");
                TimeUnit.SECONDS.sleep(this.retryDelay);
                continue;
            }
            catch (AbortException e) {
                throw e;
            }
            catch (Exception e) {
                listener.getLogger().println("[ERROR] ArmorCode request failed: " + e.getMessage());
                if (attempt == this.maxRetries) {
                    throw new AbortException("ArmorCode request error after maximum retries.");
                }
                listener.getLogger().println("Waiting " + this.retryDelay + "s before retry...");
                TimeUnit.SECONDS.sleep(this.retryDelay);
            }
        }
        if (!failureHandled) {
            listener.getLogger().println("[ERROR] ArmorCode check did not pass after " + this.maxRetries + " retries (last status was HOLD).");
            this.saveGateInfoToProperties(run, "FAIL");
            this.handleFailureMode(run, listener);
        }
    }

    protected String postArmorCodeRequest(@NonNull TaskListener listener, String token, String buildNumber, String jobName, int current, int end, String apiUrl, String jobUrl) throws Exception {
        String subProductsJsonArray;
        if (this.subProducts == null) {
            subProductsJsonArray = "[]";
        } else if (this.subProducts instanceof List) {
            subProductsJsonArray = JSONArray.fromObject((Object)this.subProducts).toString();
        } else {
            List subProductList = Arrays.stream(((String)this.subProducts).split("\\r?\\n")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            subProductsJsonArray = JSONArray.fromObject(subProductList).toString();
        }
        String payload = String.format("{ \"env\": \"%s\", \"product\": \"%s\", \"subProducts\": %s, \"buildNumber\": \"%s\", \"jobName\": \"%s\", \"current\": \"%s\", \"end\": \"%s\" , \"jobURL\": \"%s\"}", this.env, this.product, subProductsJsonArray, buildNumber, jobName, String.valueOf(current), String.valueOf(end), jobUrl);
        URL url = new URL(apiUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", "Bearer " + token);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.getOutputStream().write(payload.getBytes(StandardCharsets.UTF_8));
        conn.getOutputStream().flush();
        int responseCode = conn.getResponseCode();
        if (responseCode >= 200 && responseCode < 300) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
                String string = sb.toString();
                return string;
            }
        }
        StringBuilder errorResponse = new StringBuilder();
        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = errorReader.readLine()) != null) {
                errorResponse.append(line);
            }
        }
        catch (Exception ex) {
            errorResponse.append("Failed to read error stream: ").append(ex.getMessage());
        }
        throw new IOException("Server returned HTTP response code: " + responseCode + " for URL: " + apiUrl + " with message: " + String.valueOf(errorResponse));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    @Symbol(value={"armorcodeReleaseGate"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class jobType) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "ArmorCode Release Gate";
        }

        public String getId() {
            return "armorcodeReleaseGate";
        }

        public ListBoxModel doFillModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Block build on failure", "block");
            items.add("Warn but continue build", "warn");
            return items;
        }
    }
}

