/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.model;

import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.rest.model.Resource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportedBean
@Capability(value={"io.jenkins.blueocean.rest.model.GenericResource"})
public class GenericResource<T>
extends Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericResource.class);
    private final T value;
    private final Reachable self;

    public GenericResource(T value) {
        this.value = value;
        this.self = null;
    }

    public GenericResource(T value, Reachable self) {
        this.value = value;
        this.self = self;
    }

    @Override
    @Exported(merge=false)
    public Object getState() {
        return this.value;
    }

    public Object getDynamic(String token) {
        Class<?> clz = this.value.getClass();
        try {
            Method m = clz.getMethod("get" + Character.toUpperCase(token.charAt(0)) + token.substring(1), new Class[0]);
            return this.getResource(token, m);
        }
        catch (NoSuchMethodException e) {
            for (Method m : clz.getMethods()) {
                Exported exported = m.getAnnotation(Exported.class);
                if (exported == null || !exported.name().equals(token)) continue;
                return this.getResource(token, m);
            }
            return null;
        }
    }

    @Override
    public Link getLink() {
        return this.self != null ? this.self.getLink() : new Link(Stapler.getCurrentRequest2().getPathInfo());
    }

    private Object getResource(String token, Method m) {
        Object v;
        try {
            v = m.invoke(this.value, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ServiceException.NotFoundException("Path " + token + " is not found");
        }
        Link subResLink = this.getLink().rel(token + "/");
        if (v instanceof List) {
            return Containers.from(subResLink, (List)v);
        }
        if (v instanceof Map) {
            return Containers.from(subResLink, (Map)v);
        }
        if (v instanceof String) {
            return new PrimitiveTypeResource(subResLink, v);
        }
        return new GenericResource<Object>(v);
    }

    public static class PrimitiveTypeResource
    extends Resource {
        private final Link self;
        private final Object v;

        public PrimitiveTypeResource(Link self, Object v) {
            this.self = self;
            this.v = v;
        }

        @Override
        public Link getLink() {
            return this.self;
        }

        @Exported
        public Object getValue() {
            return this.v;
        }
    }
}

