/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.factory.organization;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import io.jenkins.blueocean.rest.factory.organization.AbstractOrganization;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import java.util.Collection;
import jenkins.model.ModifiableTopLevelItemGroup;

public abstract class OrganizationFactory
implements ExtensionPoint {
    public abstract BlueOrganization get(String var1);

    public abstract Collection<BlueOrganization> list();

    public abstract BlueOrganization of(ItemGroup var1);

    @CheckForNull
    public BlueOrganization getContainingOrg(ItemGroup p) {
        while (true) {
            BlueOrganization n;
            if ((n = this.of(p)) != null) {
                return n;
            }
            if (!(p instanceof Item)) break;
            p = ((Item)p).getParent();
        }
        return null;
    }

    @Deprecated
    @CheckForNull
    public final BlueOrganization getContainingOrg(Run r) {
        return this.getContainingOrg((Item)r.getParent());
    }

    @CheckForNull
    public final BlueOrganization getContainingOrg(Item i) {
        if (i instanceof ItemGroup) {
            return this.getContainingOrg((ItemGroup)i);
        }
        return this.getContainingOrg(i.getParent());
    }

    @NonNull
    public static OrganizationFactory getInstance() {
        OrganizationFactory r = (OrganizationFactory)ExtensionList.lookup(OrganizationFactory.class).get(0);
        if (r == null) {
            throw new AssertionError((Object)"No OrganizationFactory is installed");
        }
        return r;
    }

    @CheckForNull
    public static ModifiableTopLevelItemGroup getItemGroup(String org) {
        BlueOrganization blueOrganization = OrganizationFactory.getInstance().get(org);
        if (blueOrganization instanceof AbstractOrganization) {
            return ((AbstractOrganization)blueOrganization).getGroup();
        }
        return null;
    }

    @CheckForNull
    public static ModifiableTopLevelItemGroup getItemGroup(BlueOrganization blueOrganization) {
        if (blueOrganization instanceof AbstractOrganization) {
            return ((AbstractOrganization)blueOrganization).getGroup();
        }
        return null;
    }
}

