/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest.junit;

import hudson.Extension;
import io.jenkins.blueocean.commons.MapsHelper;
import io.jenkins.blueocean.rest.factory.BlueTrendFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.BlueTableRow;
import io.jenkins.blueocean.rest.model.BlueTestSummary;
import io.jenkins.blueocean.rest.model.BlueTrend;
import io.jenkins.blueocean.rest.model.Container;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;

@Restricted(value={NoExternalUse.class})
public class BlueJUnitTrend
extends BlueTrend {
    public static final String TOTAL = "total";
    public static final String PASSED = "passed";
    public static final String FIXED = "fixed";
    public static final String FAILED = "failed";
    public static final String EXISTING_FAILED = "existingFailed";
    public static final String REGRESSIONS = "regressions";
    public static final String SKIPPED = "skipped";
    private final BluePipeline pipeline;
    private final Link parent;
    private static final Map<String, String> COLUMNS = new MapsHelper.Builder().put((Object)"total", (Object)"Total").put((Object)"passed", (Object)"Passed").put((Object)"fixed", (Object)"Fixed").put((Object)"failed", (Object)"Failed").put((Object)"existingFailed", (Object)"Existing Failed").put((Object)"regressions", (Object)"Regressions").put((Object)"skipped", (Object)"Skipped").build();

    public BlueJUnitTrend(BluePipeline pipeline, Link parent) {
        this.pipeline = pipeline;
        this.parent = parent;
    }

    public String getId() {
        return "junit";
    }

    public String getDisplayName() {
        return "JUnit";
    }

    @Exported
    public Map<String, String> getColumns() {
        return COLUMNS;
    }

    public Container<BlueTableRow> getRows() {
        final BlueRunContainer blueRunContainer = this.pipeline.getRuns();
        return new Container<BlueTableRow>(){

            public Link getLink() {
                return BlueJUnitTrend.this.parent.rel("rows");
            }

            public BlueTableRow get(String name) {
                return null;
            }

            public Iterator<BlueTableRow> iterator() {
                return blueRunContainer == null ? null : StreamSupport.stream(blueRunContainer.spliterator(), false).map(run -> new BlueJUnitTrendRow(run.getBlueTestSummary(), run.getId())).iterator();
            }
        };
    }

    public Link getLink() {
        return this.parent.rel(this.getId());
    }

    @Extension
    public static class FactoryImpl
    extends BlueTrendFactory {
        public BlueTrend getTrend(BluePipeline pipeline, Link parent) {
            return new BlueJUnitTrend(pipeline, parent);
        }
    }

    public static class BlueJUnitTrendRow
    extends BlueTableRow {
        private final String id;
        private final BlueTestSummary summary;

        BlueJUnitTrendRow(BlueTestSummary summary, String id) {
            this.id = id;
            this.summary = summary;
        }

        public String getId() {
            return this.id;
        }

        @Exported(name="total")
        public long getTotal() {
            return this.summary.getTotal();
        }

        @Exported(name="passed")
        public long getPassed() {
            return this.summary.getPassedTotal();
        }

        @Exported(name="fixed")
        public long getFixed() {
            return this.summary.getFixedTotal();
        }

        @Exported(name="failed")
        public long getFailed() {
            return this.summary.getFailedTotal();
        }

        @Exported(name="existingFailed")
        public long getExistingFailed() {
            return this.summary.getExistingFailedTotal();
        }

        @Exported(name="regressions")
        public long getRegressions() {
            return this.summary.getRegressionsTotal();
        }

        @Exported(name="skipped")
        public long getSkipped() {
            return this.summary.getSkippedTotal();
        }
    }
}

