/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Run;
import io.jenkins.blueocean.commons.IterableUtils;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class BlueTestResultContainerImpl
extends BlueTestResultContainer {
    protected final Run<?, ?> run;

    public BlueTestResultContainerImpl(Reachable parent, Run<?, ?> run) {
        super(parent);
        this.run = run;
    }

    protected BlueTestResultFactory.Result resolve() {
        return BlueTestResultFactory.resolve(this.run, (Reachable)this.parent);
    }

    public BlueTestResult get(String name) {
        BlueTestResultFactory.Result resolved = this.resolve();
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
        BlueTestResult testResult = (BlueTestResult)IterableUtils.find((Iterable)resolved.results, blueTestResult -> blueTestResult != null && blueTestResult.getId().equals(name), null);
        if (testResult == null) {
            throw new ServiceException.NotFoundException("not found");
        }
        return testResult;
    }

    @NonNull
    public Iterator<BlueTestResult> iterator() {
        BlueTestResultFactory.Result resolved = this.resolve();
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request != null) {
            String status = request.getParameter("status");
            String state = request.getParameter("state");
            String age = request.getParameter("age");
            return this.getBlueTestResultIterator(resolved.results, status, state, age);
        }
        return resolved.results.iterator();
    }

    public Iterator<BlueTestResult> getBlueTestResultIterator(Iterable<BlueTestResult> results, String status, String state, String age) {
        if (StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)state) && StringUtils.isEmpty((String)age)) {
            return results.iterator();
        }
        Predicate<BlueTestResult> predicate = blueTestResult -> true;
        if (!StringUtils.isEmpty((String)status)) {
            predicate = predicate.and(BlueTestResultContainerImpl.filterByStatus(status));
        }
        if (!StringUtils.isEmpty((String)state)) {
            predicate = predicate.and(BlueTestResultContainerImpl.filterByState(state));
        }
        if (!StringUtils.isEmpty((String)age)) {
            predicate = predicate.and(BlueTestResultContainerImpl.filterByAge(age));
        }
        return StreamSupport.stream(results.spliterator(), false).filter(predicate).iterator();
    }

    public static Predicate<BlueTestResult> filterByAge(String age) {
        int _age;
        try {
            _age = Integer.parseInt(age);
        }
        catch (NumberFormatException ex) {
            throw new ServiceException.BadRequestException("age is not a number");
        }
        return new AgePredicate(_age);
    }

    public static Predicate<BlueTestResult> filterByStatus(String status) {
        String[] statusAtoms = StringUtils.split((String)status, (char)',');
        Predicate<BlueTestResult> predicate = blueTestResult -> false;
        if (statusAtoms == null || statusAtoms.length == 0) {
            throw new ServiceException.BadRequestException("status not provided");
        }
        for (String statusString : statusAtoms) {
            Predicate<BlueTestResult> statusPredicate;
            try {
                if (statusString.startsWith("!")) {
                    StatusPredicate tmp = new StatusPredicate(BlueTestResult.Status.valueOf((String)statusString.toUpperCase().substring(1)));
                    statusPredicate = blueTestResult -> !tmp.test((BlueTestResult)blueTestResult);
                } else {
                    statusPredicate = new StatusPredicate(BlueTestResult.Status.valueOf((String)statusString.toUpperCase()));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException.BadRequestException("bad status " + status, (Throwable)e);
            }
            predicate = predicate.or(statusPredicate);
        }
        return predicate;
    }

    public static Predicate<BlueTestResult> filterByState(String state) {
        String[] stateAtoms = StringUtils.split((String)state, (char)',');
        Predicate<BlueTestResult> predicate = blueTestResult -> false;
        if (stateAtoms == null || stateAtoms.length == 0) {
            throw new ServiceException.BadRequestException("state not provided");
        }
        for (String stateString : stateAtoms) {
            Predicate<BlueTestResult> statePredicate;
            try {
                if (stateString.startsWith("!")) {
                    StatePredicate tmp = new StatePredicate(BlueTestResult.State.valueOf((String)stateString.toUpperCase().substring(1)));
                    statePredicate = blueTestResult -> !tmp.test((BlueTestResult)blueTestResult);
                } else {
                    statePredicate = new StatePredicate(BlueTestResult.State.valueOf((String)stateString.toUpperCase()));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceException.BadRequestException("bad state " + state, (Throwable)e);
            }
            predicate = predicate.or(statePredicate);
        }
        return predicate;
    }

    static class AgePredicate
    implements Predicate<BlueTestResult> {
        private final Integer age;

        public AgePredicate(Integer age) {
            this.age = age;
        }

        @Override
        public boolean test(@Nullable BlueTestResult input) {
            if (input == null) {
                return false;
            }
            if (this.age > 0) {
                return input.getAge() >= this.age;
            }
            if (this.age < 0) {
                return input.getAge() <= Math.abs(this.age);
            }
            return input.getAge() == this.age.intValue();
        }
    }

    static class StatusPredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.Status status;

        StatusPredicate(BlueTestResult.Status status) {
            this.status = status;
        }

        @Override
        public boolean test(@Nullable BlueTestResult input) {
            return input != null && input.getStatus().equals((Object)this.status);
        }
    }

    static class StatePredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.State state;

        StatePredicate(BlueTestResult.State state) {
            this.state = state;
        }

        @Override
        public boolean test(@Nullable BlueTestResult input) {
            return input != null && input.getTestState().equals((Object)this.state);
        }
    }
}

