/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import io.jenkins.blueocean.service.embedded.util.GlobMatcher;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PipelineSearch
extends OmniSearch<BluePipeline> {
    private static final String EXCLUDED_FROM_FLATTENING_PARAM = "excludedFromFlattening";
    private static final String ORGANIZATION_PARAM = "organization";
    private static final Logger logger = LoggerFactory.getLogger(PipelineSearch.class);

    public String getType() {
        return "pipeline";
    }

    public Pageable<BluePipeline> search(Query q) {
        GlobMatcher matcher;
        Plugin p;
        String s = q.param(EXCLUDED_FROM_FLATTENING_PARAM);
        ItemGroup orgItemGroup = this.findItemGroup(q);
        ArrayList<Class> excludeList = new ArrayList<Class>();
        if (s != null) {
            for (String s1 : s.split(",")) {
                Class<?> c = null;
                try {
                    c = Class.forName(s1);
                }
                catch (ClassNotFoundException e) {
                    try {
                        p = Jenkins.get().getPlugin("blueocean-pipeline-api-impl");
                        if (p != null) {
                            c = p.getWrapper().classLoader.loadClass(s1);
                        } else {
                            logger.error("blueocean-pipeline-api-impl plugin not found!");
                        }
                    }
                    catch (ClassNotFoundException e1) {
                        logger.error(e.getMessage(), (Throwable)e1);
                    }
                }
                if (c == null) continue;
                excludeList.add(c);
            }
        }
        Collection<Object> items = new ArrayList();
        if (!excludeList.isEmpty()) {
            for (Item item : this.getAllItems(orgItemGroup)) {
                if (this.exclude(item.getParent(), excludeList)) continue;
                items.add(item);
            }
        } else {
            items = this.getAllItems(orgItemGroup);
        }
        items = ContainerFilter.filter(items);
        BlueOrganization org = OrganizationFactory.getInstance().getContainingOrg(orgItemGroup);
        if (org == null) {
            throw new ServiceException.UnexpectedErrorException("Could not find organization");
        }
        Iterator<BluePipeline> pipelineIterator = new PipelineContainerImpl(org, orgItemGroup, (Reachable)org).getPipelines(items);
        ArrayList<Plugin> pipelines = new ArrayList<Plugin>();
        String pipeline = q.param(this.getType());
        if (pipeline == null) {
            return Pageables.wrap(() -> pipelineIterator);
        }
        GlobMatcher globMatcher = matcher = pipeline.contains("*") ? new GlobMatcher(pipeline) : null;
        if (matcher != null) {
            while (pipelineIterator.hasNext()) {
                p = pipelineIterator.next();
                String decodedName = null;
                try {
                    decodedName = URLDecoder.decode(p.getFullDisplayName(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ServiceException.UnexpectedErrorException("Could not decode '" + p.getFullDisplayName() + "'", (Throwable)e);
                }
                if (!matcher.matches(decodedName)) continue;
                pipelines.add(p);
            }
        } else {
            while (pipelineIterator.hasNext()) {
                p = pipelineIterator.next();
                if (!pipeline.equals(p.getFullDisplayName())) continue;
                pipelines.add(p);
            }
        }
        return Pageables.wrap(pipelines);
    }

    private List<Item> getAllItems(ItemGroup org) {
        ArrayList<Item> r = new ArrayList<Item>();
        this.getAllItems(org, r);
        return r;
    }

    private void getAllItems(ItemGroup<?> org, List<Item> r) {
        for (Item i : org.getItems()) {
            r.add(i);
            if (!(i instanceof ItemGroup)) continue;
            this.getAllItems((ItemGroup)i, r);
        }
    }

    private ItemGroup findItemGroup(Query q) {
        String org = q.param(ORGANIZATION_PARAM);
        if (org == null) {
            return Jenkins.get();
        }
        ModifiableTopLevelItemGroup group = OrganizationFactory.getItemGroup((String)org);
        if (group == null) {
            throw new ServiceException.BadRequestException(String.format("Organization %s not found. Query parameter %s value: %s is invalid. ", org, ORGANIZATION_PARAM, org));
        }
        return group;
    }

    private boolean exclude(ItemGroup item, List<Class> excludeList) {
        for (Class c : excludeList) {
            if (!c.isAssignableFrom(item.getClass())) continue;
            return true;
        }
        return false;
    }
}

