/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueArtifactFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.StreamSupport;

public class ArtifactContainerImpl
extends BlueArtifactContainer {
    private final Run run;
    private final Link self;

    public ArtifactContainerImpl(Run r, Reachable parent) {
        this.run = r;
        this.self = parent.getLink().rel("artifacts");
    }

    public Link getLink() {
        return this.self;
    }

    public BlueArtifact get(String name) {
        if (Functions.isArtifactsPermissionEnabled() && !this.run.hasPermission(Run.ARTIFACTS)) {
            return null;
        }
        return StreamSupport.stream(this.iterable().spliterator(), false).filter(input -> input != null && name.equals(input.getId())).findFirst().orElse(null);
    }

    @NonNull
    public Iterator<BlueArtifact> iterator() {
        return this.iterable().iterator();
    }

    Iterable<BlueArtifact> iterable() {
        if (Functions.isArtifactsPermissionEnabled() && !this.run.hasPermission(Run.ARTIFACTS)) {
            return Collections.emptyList();
        }
        return BlueArtifactFactory.resolve((Run)this.run, (Reachable)this);
    }
}

