/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.model.User;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.util.ArrayList;

@Extension
public class UserSearch
extends OmniSearch<BlueUser> {
    public String getType() {
        return "user";
    }

    public Pageable<BlueUser> search(Query q) {
        ArrayList<UserImpl> users = new ArrayList<UserImpl>();
        BlueOrganization organization = this.getOrganization(q);
        if (organization == null) {
            organization = (BlueOrganization)OrganizationFactory.getInstance().list().iterator().next();
        }
        for (User u : User.getAll()) {
            users.add(new UserImpl(organization, u));
        }
        return Pageables.wrap(users);
    }

    public BlueOrganization getOrganization(Query q) {
        String org = q.param("organization");
        if (org == null) {
            return null;
        }
        BlueOrganization organization = OrganizationFactory.getInstance().get(org);
        return organization;
    }
}

