/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.AnnotatedLargeText;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.service.embedded.rest.LogAppender;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;

public class LogResource {
    public static final long DEFAULT_LOG_THRESHOLD = 150L;
    private final AnnotatedLargeText logText;
    private final Reader appenderLogReader;

    public LogResource(AnnotatedLargeText log) {
        this(log, LogAppender.DEFAULT);
    }

    public LogResource(@NonNull AnnotatedLargeText log, @NonNull LogAppender logAppender) {
        this.logText = log;
        this.appenderLogReader = logAppender.getLog();
    }

    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) {
        this.writeLog(req, rsp);
    }

    private void writeLog(StaplerRequest2 req, StaplerResponse2 rsp) {
        try {
            String download = req.getParameter("download");
            if ("true".equalsIgnoreCase(download)) {
                rsp.setHeader("Content-Disposition", "attachment; filename=log.txt");
            }
            rsp.setContentType("text/plain;charset=UTF-8");
            rsp.setStatus(200);
            this.writeLogs(req, rsp);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to get logText: " + e.getMessage(), (Throwable)e);
        }
    }

    private void writeLogs(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        long threshold = 153600L;
        String s = req.getParameter("thresholdInKB");
        if (s != null) {
            threshold = Long.parseLong(s) * 1024L;
        }
        long offset = req.getParameter("start") != null ? Long.parseLong(req.getParameter("start")) : (this.logText.length() > threshold ? this.logText.length() - threshold : 0L);
        CharSpool spool = new CharSpool();
        long r = this.logText.writeLogTo(offset, (Writer)spool);
        Writer w = this.createWriter(req, rsp, r - offset);
        spool.writeTo((Writer)new LineEndNormalizingWriter(w));
        if (!this.logText.isComplete()) {
            rsp.addHeader("X-More-Data", "true");
        } else {
            int text = this.appenderLogReader.read();
            while (text != -1) {
                w.write(text);
                ++r;
                text = this.appenderLogReader.read();
            }
        }
        rsp.addHeader("X-Text-Size", String.valueOf(r));
        rsp.addHeader("X-Text-Delivered", String.valueOf(r - offset));
        w.close();
    }

    private Writer createWriter(StaplerRequest2 req, StaplerResponse2 rsp, long size) throws IOException {
        if (size > 4096L) {
            return rsp.getCompressedWriter((HttpServletRequest)req);
        }
        return rsp.getWriter();
    }
}

