/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.pipeline.credential.Messages;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(ordinal=99999.0)
public class BlueOceanCredentialsProvider
extends CredentialsProvider {
    private static final BlueOceanDomainRequirement PROXY_REQUIREMENT = new BlueOceanDomainRequirement();
    private static final Logger logger = LoggerFactory.getLogger(BlueOceanCredentialsProvider.class);

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull ItemGroup itemGroup, @NonNull Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.emptyList());
    }

    private static boolean IsSystemPropertyEnabled() {
        return SystemProperties.getBoolean((String)(BlueOceanCredentialsProvider.class.getName() + ".enabled"));
    }

    public boolean isEnabled(Object context) {
        return BlueOceanCredentialsProvider.IsSystemPropertyEnabled() && super.isEnabled(context);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        User proxyUser;
        if (!BlueOceanCredentialsProvider.IsSystemPropertyEnabled()) {
            return Collections.emptyList();
        }
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        FolderPropertyImpl prop = BlueOceanCredentialsProvider.propertyOf((ModelObject)itemGroup);
        if (prop != null && prop.domain.test(domainRequirements) && (proxyUser = User.get((String)prop.getUser(), (boolean)false, Collections.emptyMap())) != null) {
            try (ACLContext ignored = ACL.as((Authentication)proxyUser.impersonate());){
                for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)proxyUser)) {
                    for (Domain d : s.getDomains()) {
                        if (!d.test(new DomainRequirement[]{PROXY_REQUIREMENT})) continue;
                        for (Credentials c : CredentialsMatchers.filter((List)s.getCredentials(d), (CredentialsMatcher)CredentialsMatchers.withId((String)prop.getId()))) {
                            if (!type.isInstance(c)) continue;
                            result.add(c);
                        }
                    }
                }
            }
            catch (UsernameNotFoundException ex) {
                logger.warn("BlueOceanCredentialsProvider#getCredentials(): Username attached to credentials can not be found");
            }
        }
        return result;
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        if (!BlueOceanCredentialsProvider.IsSystemPropertyEnabled()) {
            return new ListBoxModel();
        }
        ListBoxModel result = new ListBoxModel();
        FolderPropertyImpl prop = BlueOceanCredentialsProvider.propertyOf((ModelObject)itemGroup);
        if (prop != null && prop.domain.test(domainRequirements)) {
            result.add(Messages.BlueOceanCredentialsProvider_DisplayName(), prop.getId());
        }
        return result;
    }

    @NonNull
    public String getDisplayName() {
        return Messages.BlueOceanCredentialsProvider_DisplayName();
    }

    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        if (!BlueOceanCredentialsProvider.IsSystemPropertyEnabled()) {
            return null;
        }
        FolderPropertyImpl property = BlueOceanCredentialsProvider.propertyOf(object);
        return property != null ? property.getStore() : null;
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return Collections.singleton(CredentialsScope.GLOBAL);
    }

    private boolean isApplicable(ModelObject object) {
        return object instanceof AbstractFolder && ((AbstractFolder)object).getProperties().get(FolderPropertyImpl.class) != null;
    }

    private static FolderPropertyImpl propertyOf(ModelObject object) {
        if (object instanceof AbstractFolder) {
            FolderPropertyImpl prop = (FolderPropertyImpl)((AbstractFolder)object).getProperties().get(FolderPropertyImpl.class);
            if (prop == null) {
                ItemGroup parent = ((AbstractFolder)object).getParent();
                if (parent instanceof Jenkins) {
                    return null;
                }
                return BlueOceanCredentialsProvider.propertyOf((ModelObject)parent);
            }
            return prop;
        }
        return null;
    }

    @NonNull
    public static Domain createDomain(@NonNull String uri) {
        return new Domain("blueocean-folder-credential-domain", Messages.BlueOceanCredentialsProvider_DomainDescription(), CredentialsUtils.generateDomainSpecifications(uri));
    }

    public static class FolderPropertyImpl
    extends AbstractFolderProperty<AbstractFolder<TopLevelItem>> {
        private final Domain domain;
        private final String user;
        private final String id;
        private transient StoreImpl store;

        @DataBoundConstructor
        public FolderPropertyImpl(@NonNull String user, @NonNull String id, @NonNull Domain domain) {
            this.user = user;
            this.id = id;
            this.domain = domain;
        }

        public StoreImpl getStore() {
            if (this.store == null) {
                this.store = new StoreImpl();
            }
            return this.store;
        }

        @NonNull
        public String getUser() {
            return this.user;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        @NonNull
        public Domain getDomain() {
            return this.domain;
        }

        public AbstractFolderProperty<?> reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
            return this;
        }

        public class StoreImpl
        extends CredentialsStore {
            private final CredentialsStoreAction storeAction;

            StoreImpl() {
                super(BlueOceanCredentialsProvider.class);
                this.storeAction = new CredentialsStoreActionImpl(this);
            }

            @NonNull
            public List<Domain> getDomains() {
                return Collections.singletonList(FolderPropertyImpl.this.domain);
            }

            @Nullable
            public CredentialsStoreAction getStoreAction() {
                return this.storeAction;
            }

            @NonNull
            public ModelObject getContext() {
                return FolderPropertyImpl.this.owner;
            }

            public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
                if (permission == CredentialsProvider.CREATE || permission == CredentialsProvider.DELETE || permission == CredentialsProvider.MANAGE_DOMAINS || permission == CredentialsProvider.UPDATE) {
                    return false;
                }
                return FolderPropertyImpl.this.owner.getACL().hasPermission(a, permission);
            }

            @NonNull
            public List<Credentials> getCredentials(@NonNull Domain domain) {
                User proxyUser;
                if (!BlueOceanCredentialsProvider.IsSystemPropertyEnabled()) {
                    return Collections.emptyList();
                }
                ArrayList<Credentials> result = new ArrayList<Credentials>(1);
                if (domain.equals((Object)FolderPropertyImpl.this.domain) && (proxyUser = User.get((String)FolderPropertyImpl.this.getUser(), (boolean)false, Collections.emptyMap())) != null) {
                    try (ACLContext ignored = ACL.as((Authentication)proxyUser.impersonate());){
                        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)proxyUser)) {
                            for (Domain d : s.getDomains()) {
                                if (!d.test(new DomainRequirement[]{PROXY_REQUIREMENT})) continue;
                                result.addAll(CredentialsMatchers.filter((List)s.getCredentials(d), (CredentialsMatcher)CredentialsMatchers.withId((String)FolderPropertyImpl.this.getId())));
                            }
                        }
                    }
                    catch (UsernameNotFoundException ex) {
                        logger.warn("BlueOceanCredentialsProvider.StoreImpl#getCredentials(): Username attached to credentials can not be found");
                    }
                }
                return result;
            }

            public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
                throw new UnsupportedOperationException("Not supported");
            }

            public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
                throw new UnsupportedOperationException("Not supported");
            }

            public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
                throw new UnsupportedOperationException("Not supported");
            }
        }

        public static class CredentialsStoreActionImpl
        extends CredentialsStoreAction {
            private final CredentialsStore store;

            CredentialsStoreActionImpl(CredentialsStore store) {
                this.store = store;
            }

            @NonNull
            public CredentialsStore getStore() {
                return this.store;
            }

            public String getIconFileName() {
                return this.isVisible() ? "/plugin/credentials/images/48x48/folder-store.png" : null;
            }

            public String getIconClassName() {
                return this.isVisible() ? "icon-credentials-folder-store" : null;
            }

            public String getDisplayName() {
                return Messages.BlueOceanCredentialsProvider_DisplayName();
            }

            public String getUrlName() {
                return super.getUrlName();
            }
        }

        @Extension
        public static class DescriptorImpl
        extends AbstractFolderPropertyDescriptor {
        }
    }
}

