/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionPoint;
import hudson.model.UnprotectedRootAction;
import io.jenkins.blueocean.auth.jwt.JwtSigningKeyProvider;
import io.jenkins.blueocean.auth.jwt.JwtToken;
import io.jenkins.blueocean.auth.jwt.SigningPublicKey;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;

public abstract class JwtAuthenticationService
implements UnprotectedRootAction,
ExtensionPoint {
    public String getUrlName() {
        return "jwt-auth";
    }

    @GET
    @WebMethod(name={"token"})
    public abstract JwtToken getToken(@QueryParameter(value="expiryTimeInMins") @Nullable Integer var1, @QueryParameter(value="maxExpiryTimeInMins") @Nullable Integer var2);

    @GET
    public SigningPublicKey getJwks(String keyId) {
        return JwtSigningKeyProvider.toPublicKey(keyId);
    }

    @GET
    @WebMethod(name={"jwk-set"})
    public abstract JSONObject getJwkSet();
}

