/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.jira;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.jira.JiraBuildAction;
import hudson.plugins.jira.JiraJobAction;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.factory.BlueIssueFactory;
import io.jenkins.blueocean.rest.model.BlueIssue;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class BlueJiraIssue
extends BlueIssue {
    private static final Logger LOGGER = Logger.getLogger(BlueJiraIssue.class.getName());
    private final String issueKey;
    private final String issueURL;

    public BlueJiraIssue(String issueKey, String issueURL) {
        this.issueKey = issueKey;
        this.issueURL = issueURL;
    }

    public String getId() {
        return this.issueKey;
    }

    public String getURL() {
        return this.issueURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BlueJiraIssue that = (BlueJiraIssue)((Object)o);
        return Objects.equals(this.issueKey, that.issueKey) && Objects.equals(this.issueURL, that.issueURL);
    }

    public int hashCode() {
        return Objects.hash(this.issueKey, this.issueURL);
    }

    static Collection<String> findIssueKeys(String input, Pattern pattern) {
        Matcher m = pattern.matcher(input);
        HashSet<String> issues = new HashSet<String>();
        while (m.find()) {
            if (m.groupCount() < 1) continue;
            String id = m.group(1);
            issues.add(id);
        }
        return issues;
    }

    @CheckForNull
    static BlueIssue create(@NonNull JiraSite site, @Nullable JiraIssue issue) {
        if (issue == null) {
            return null;
        }
        try {
            return new BlueJiraIssue(issue.getKey(), site.getUrl(issue).toString());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Extension
    public static class FactoryImpl
    extends BlueIssueFactory {
        public Collection<BlueIssue> getIssues(Job job) {
            JiraSite jiraSite = JiraSite.get((Job)job);
            if (jiraSite == null) {
                return null;
            }
            JiraJobAction action = (JiraJobAction)job.getAction(JiraJobAction.class);
            if (action == null) {
                return null;
            }
            BlueIssue issue = BlueJiraIssue.create(jiraSite, action.getIssue());
            if (issue == null) {
                return null;
            }
            return Collections.singletonList(issue);
        }

        public Collection<BlueIssue> getIssues(ChangeLogSet.Entry changeSetEntry) {
            Run run = changeSetEntry.getParent().getRun();
            JiraSite site = JiraSite.get((Job)run.getParent());
            if (site == null) {
                return null;
            }
            JiraBuildAction action = (JiraBuildAction)run.getAction(JiraBuildAction.class);
            if (action == null) {
                return null;
            }
            Collection<String> issueKeys = BlueJiraIssue.findIssueKeys(changeSetEntry.getMsg(), site.getIssuePattern());
            Collection blueIssues = issueKeys.stream().map(s -> BlueJiraIssue.create(site, action.getIssue(s))).filter(Objects::nonNull).collect(Collectors.toList());
            return Collections.unmodifiableCollection(blueIssues);
        }
    }
}

