/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_github_pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubCredentialUtils;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubScm;
import io.jenkins.blueocean.blueocean_github_pipeline.GithubServerContainer;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.scm.Scm;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmFactory;
import io.jenkins.blueocean.rest.impl.pipeline.scm.ScmServerEndpointContainer;

public class GithubEnterpriseScm
extends GithubScm {
    static final String ID = "github-enterprise";
    static final String DOMAIN_NAME = "blueocean-github-enterprise-domain";
    static final String CREDENTIAL_DESCRIPTION = "GitHub Enterprise Access Token";

    public GithubEnterpriseScm(Reachable parent) {
        super(parent);
    }

    @Override
    @NonNull
    public String getId() {
        return ID;
    }

    @Override
    @NonNull
    public String getUri() {
        String apiUri = this.getCustomApiUri();
        if (apiUri == null || apiUri.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "apiUrl is required parameter"));
        }
        return apiUri;
    }

    @Override
    public String getCredentialId() {
        StandardUsernamePasswordCredentials githubCredential = this.getCredential(this.getUri());
        if (githubCredential != null) {
            return githubCredential.getId();
        }
        return null;
    }

    @Override
    public String getCredentialDomainName() {
        return DOMAIN_NAME;
    }

    @Override
    public boolean isOrganizationAvatarSupported() {
        return false;
    }

    @Override
    public Object getState() {
        this.getUri();
        return super.getState();
    }

    @Override
    @Navigable
    public ScmServerEndpointContainer getServers() {
        return new GithubServerContainer(this.getLink());
    }

    @Override
    @NonNull
    protected String createCredentialId(@NonNull String apiUri) {
        return GithubCredentialUtils.computeCredentialId(null, ID, apiUri);
    }

    @Override
    @NonNull
    protected String getCredentialDescription() {
        return CREDENTIAL_DESCRIPTION;
    }

    @Override
    public Link getLink() {
        return this.parent.getLink().rel(ID);
    }

    @Extension
    public static class GithubScmFactory
    extends ScmFactory {
        public Scm getScm(String id, Reachable parent) {
            if (id.equals(GithubEnterpriseScm.ID)) {
                return new GithubEnterpriseScm(parent);
            }
            return null;
        }

        @NonNull
        public Scm getScm(Reachable parent) {
            return new GithubEnterpriseScm(parent);
        }
    }
}

