/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_git_pipeline;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitTool;
import hudson.remoting.VirtualChannel;
import hudson.tasks.MailAddressResolver;
import hudson.util.LogTaskListener;
import io.jenkins.blueocean.blueocean_git_pipeline.GitReadSaveRequest;
import io.jenkins.blueocean.blueocean_git_pipeline.GitUtils;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

class GitBareRepoReadSaveRequest
extends GitReadSaveRequest {
    private static final String LOCAL_REF_BASE = "refs/remotes/origin/";
    private static final String REMOTE_REF_BASE = "refs/heads/";
    private final File repositoryPath;
    private final GitTool gitTool;

    GitBareRepoReadSaveRequest(AbstractGitSCMSource gitSource, String branch, String commitMessage, String sourceBranch, String filePath, byte[] contents) {
        super(gitSource, branch, commitMessage, sourceBranch, filePath, contents);
        GitTool.DescriptorImpl toolDesc = (GitTool.DescriptorImpl)Jenkins.get().getDescriptorByType(GitTool.DescriptorImpl.class);
        GitTool foundGitTool = null;
        if (gitSource != null) {
            for (SCMSourceTrait trait : gitSource.getTraits()) {
                if (!(trait instanceof GitToolSCMSourceTrait)) continue;
                foundGitTool = toolDesc.getInstallation(((GitToolSCMSourceTrait)trait).getGitTool());
            }
        }
        if (foundGitTool == null) {
            foundGitTool = GitTool.getDefaultInstallation();
        }
        this.gitTool = foundGitTool;
        try {
            this.repositoryPath = Files.createTempDirectory("git", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Unable to create working directory for repository clone");
        }
    }

    @Override
    byte[] read() throws IOException {
        return (byte[])this.invokeOnScm(repo -> {
            GitUtils.validatePushAccess(repo, this.gitSource.getRemote(), this.getCredential());
            GitUtils.fetch(repo, this.getCredential());
            return GitUtils.readFile(repo, LOCAL_REF_BASE + this.branch, this.filePath);
        });
    }

    @Override
    void save() throws IOException {
        this.invokeOnScm(repo -> {
            String localBranchRef = LOCAL_REF_BASE + this.sourceBranch;
            ObjectId branchHead = repo.resolve(localBranchRef);
            try {
                User user = User.current();
                if (user == null) {
                    throw new ServiceException.UnauthorizedException("Not authenticated");
                }
                Object mailAddress = MailAddressResolver.resolve((User)user);
                if (mailAddress == null) {
                    mailAddress = user.getId() + "@email-address-not-set";
                }
                StandardCredentials credential = this.getCredential();
                GitUtils.fetch(repo, credential);
                GitUtils.commit(repo, localBranchRef, this.filePath, this.contents, user.getId(), (String)mailAddress, this.commitMessage, TimeZone.getDefault(), new Date());
                GitUtils.push(this.gitSource.getRemote(), repo, credential, localBranchRef, REMOTE_REF_BASE + this.branch);
                Void void_ = null;
                return void_;
            }
            finally {
                try {
                    if (branchHead != null) {
                        RefUpdate rollback = repo.updateRef(localBranchRef);
                        rollback.setNewObjectId((AnyObjectId)branchHead);
                        rollback.forceUpdate();
                    }
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "Unable to roll back repo after save failure", ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T invokeOnScm(GitSCMFileSystem.FSFunction<T> function) throws IOException {
        try {
            GitSCMFileSystem fs = this.getFilesystem();
            if (fs != null) return (T)fs.invoke(function);
            GitClient git = this.cloneRepo();
            try {
                Object object = git.withRepository(new RepositoryCallbackToFSFunctionAdapter<T>(function));
                return (T)object;
            }
            finally {
                this.cleanupRepo();
            }
        }
        catch (InterruptedException ex) {
            throw new ServiceException.UnexpectedErrorException("Unable to save " + this.filePath, (Throwable)ex);
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="TODO check if this NPE is still real, and if so fix it")
    private GitSCMFileSystem getFilesystem() throws IOException, InterruptedException {
        try {
            return (GitSCMFileSystem)SCMFileSystem.of((SCMSource)this.gitSource, (SCMHead)new SCMHead(this.sourceBranch));
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (GitException e) {
            if (e.getMessage().contains("Permission denied")) {
                throw new ServiceException.UnauthorizedException("Not authorized", (Throwable)e);
            }
            throw e;
        }
    }

    GitClient cloneRepo() throws InterruptedException, IOException {
        EnvVars environment = new EnvVars();
        LogTaskListener taskListener = new LogTaskListener(Logger.getAnonymousLogger(), Level.ALL);
        String gitExe = this.gitTool.getGitExe();
        GitClient git = Git.with((TaskListener)taskListener, (EnvVars)environment).in(this.repositoryPath).using(gitExe).getClient();
        git.addCredentials(this.gitSource.getRemote(), this.getCredential());
        try {
            git.clone(this.gitSource.getRemote(), "origin", true, null);
            log.fine("Repository " + this.gitSource.getRemote() + " cloned to: " + this.repositoryPath.getCanonicalPath());
        }
        catch (GitException e) {
            boolean isEmptyRepo;
            block6: {
                isEmptyRepo = false;
                try {
                    if (git.getRemoteReferences(this.gitSource.getRemote(), null, true, false).isEmpty()) {
                        isEmptyRepo = true;
                    }
                }
                catch (GitException ge) {
                    if (!"unexpected ls-remote output ".equals(ge.getMessage())) break block6;
                    isEmptyRepo = true;
                }
            }
            if (isEmptyRepo) {
                git.init();
                git.addRemoteUrl("origin", this.gitSource.getRemote());
                log.fine("Repository " + this.gitSource.getRemote() + " not found, created new to: " + this.repositoryPath.getCanonicalPath());
            }
            throw e;
        }
        return git;
    }

    void cleanupRepo() {
        try {
            FileUtils.deleteDirectory((File)this.repositoryPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class RepositoryCallbackToFSFunctionAdapter<T>
    implements RepositoryCallback<T> {
        private final GitSCMFileSystem.FSFunction<T> function;

        public RepositoryCallbackToFSFunctionAdapter(GitSCMFileSystem.FSFunction<T> function) {
            this.function = function;
        }

        public T invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
            return (T)this.function.invoke(repo);
        }
    }
}

