/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.PluginWrapper;
import io.jenkins.blueocean.rest.model.BlueExtensionClass;
import io.jenkins.blueocean.rest.model.BlueExtensionClassContainer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Restricted(value={NoExternalUse.class})
public class JenkinsJSExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenkinsJSExtensions.class);
    private static final String PLUGIN_ID = "hpiPluginId";
    private static final String PLUGIN_VER = "hpiPluginVer";
    private static final String PLUGIN_EXT = "extensions";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final List<PluginWrapper> pluginCache = new CopyOnWriteArrayList<PluginWrapper>();
    private static final Map<String, Object> jsExtensionCache = new ConcurrentHashMap<String, Object>();

    public static JSONArray getExtensionsData() {
        Collection<Object> jsExtensionData = JenkinsJSExtensions.getJenkinsJSExtensionData();
        JSONArray jsExtensionDataJson = JSONArray.fromObject(jsExtensionData);
        return jsExtensionDataJson;
    }

    static Collection<Object> getJenkinsJSExtensionData() {
        JenkinsJSExtensions.refreshCacheIfNeeded();
        return jsExtensionCache.values();
    }

    private static String getGav(Map ext) {
        return (String)ext.get(PLUGIN_ID);
    }

    private static void refreshCacheIfNeeded() {
        List latestPlugins = Jenkins.get().getPluginManager().getPlugins();
        if (!latestPlugins.equals(pluginCache)) {
            JenkinsJSExtensions.refreshCache(latestPlugins);
        }
    }

    private static synchronized void refreshCache(List<PluginWrapper> latestPlugins) {
        if (!latestPlugins.equals(pluginCache)) {
            pluginCache.clear();
            pluginCache.addAll(latestPlugins);
            JenkinsJSExtensions.refreshCache(pluginCache);
        }
        for (PluginWrapper pluginWrapper : pluginCache) {
            if (!pluginWrapper.isActive() || jsExtensionCache.get(pluginWrapper.getLongName()) != null) continue;
            try {
                Enumeration<URL> dataResources = pluginWrapper.classLoader.getResources("jenkins-js-extension.json");
                boolean hasDefinedExtensions = false;
                while (dataResources.hasMoreElements()) {
                    URL dataRes = dataResources.nextElement();
                    LOGGER.debug("Reading 'jenkins-js-extension.json' from '{}'.", (Object)dataRes);
                    InputStream dataResStream = dataRes.openStream();
                    try {
                        Map extensionData = (Map)mapper.readValue(dataResStream, Map.class);
                        String pluginId = JenkinsJSExtensions.getGav(extensionData);
                        if (pluginId != null) {
                            if (!pluginId.equals(pluginWrapper.getShortName())) {
                                continue;
                            }
                        } else {
                            LOGGER.error(String.format("Plugin %s JS extension has missing hpiPluginId", pluginWrapper.getLongName()));
                            continue;
                        }
                        List extensions = (List)extensionData.get(PLUGIN_EXT);
                        if (extensions != null) {
                            for (Map extension : extensions) {
                                try {
                                    String type = (String)extension.get("type");
                                    if (type == null) continue;
                                    BlueExtensionClassContainer extensionClassContainer = (BlueExtensionClassContainer)Jenkins.get().getExtensionList(BlueExtensionClassContainer.class).get(0);
                                    Map classInfo = (Map)JenkinsJSExtensions.mergeObjects(extensionClassContainer.get(type));
                                    List classInfoClasses = (List)classInfo.get("_classes");
                                    classInfoClasses.add(0, type);
                                    extension.put("_class", type);
                                    extension.put("_classes", classInfoClasses);
                                }
                                catch (Exception e) {
                                    LOGGER.error("An error occurred when attempting to read type information from jenkins-js-extension.json from: " + String.valueOf(dataRes), (Throwable)e);
                                }
                            }
                        }
                        extensionData.put(PLUGIN_VER, pluginWrapper.getVersion());
                        jsExtensionCache.put(pluginId, JenkinsJSExtensions.mergeObjects(extensionData));
                        hasDefinedExtensions = true;
                    }
                    finally {
                        if (dataResStream == null) continue;
                        dataResStream.close();
                    }
                }
                if (hasDefinedExtensions) continue;
                LinkedHashMap<String, Object> extensionData = new LinkedHashMap<String, Object>();
                extensionData.put(PLUGIN_ID, pluginWrapper.getShortName());
                extensionData.put(PLUGIN_VER, pluginWrapper.getVersion());
                extensionData.put(PLUGIN_EXT, Collections.emptyList());
                jsExtensionCache.put(pluginWrapper.getShortName(), JenkinsJSExtensions.mergeObjects(extensionData));
            }
            catch (IOException e) {
                LOGGER.error(String.format("Error locating jenkins-js-extension.json for plugin %s", pluginWrapper.getLongName()));
            }
        }
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    private static Object mergeObjects(Object incoming) {
        if (incoming instanceof Map) {
            HashMap m = new HashMap();
            Map in = (Map)incoming;
            for (Object key : in.keySet()) {
                Object value = JenkinsJSExtensions.mergeObjects(in.get(key));
                m.put(key, value);
            }
            return m;
        }
        if (incoming instanceof Collection) {
            ArrayList l = new ArrayList();
            for (Object i : (Collection)incoming) {
                i = JenkinsJSExtensions.mergeObjects(i);
                l.add(i);
            }
            return l;
        }
        if (incoming instanceof Class) {
            return ((Class)incoming).getName();
        }
        if (incoming instanceof BlueExtensionClass) {
            BlueExtensionClass in = (BlueExtensionClass)incoming;
            HashMap<String, Object> m = new HashMap<String, Object>();
            Object value = JenkinsJSExtensions.mergeObjects(in.getClasses());
            m.put("_classes", value);
            return m;
        }
        return incoming;
    }
}

