/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.commons.stapler.export;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.commons.stapler.export.DataWriter;
import io.jenkins.blueocean.commons.stapler.export.ExportConfig;
import io.jenkins.blueocean.commons.stapler.export.ExportInterceptor;
import io.jenkins.blueocean.commons.stapler.export.FilteringTreePruner;
import io.jenkins.blueocean.commons.stapler.export.Model;
import io.jenkins.blueocean.commons.stapler.export.ModelBuilder;
import io.jenkins.blueocean.commons.stapler.export.NotExportableException;
import io.jenkins.blueocean.commons.stapler.export.Range;
import io.jenkins.blueocean.commons.stapler.export.TreePruner;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.export.CustomExportedBean;
import org.kohsuke.stapler.export.Exported;

public abstract class Property
implements Comparable<Property> {
    private static final Logger LOGGER = Logger.getLogger(Property.class.getName());
    public final String name;
    final ModelBuilder owner;
    public final int visibility;
    public final Model parent;
    public final boolean inline;
    public final boolean merge;
    private final boolean skipNull;
    private String[] verboseMap;
    private final Type type;
    static final Set<Class> STRING_TYPES = new HashSet<Class>(Arrays.asList(String.class, URL.class));
    static final Set<Class> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(Integer.class, Long.class, Boolean.class, Short.class, Character.class, Float.class, Double.class));

    Property(Model parent, String name, Type type, Exported exported) {
        this.parent = parent;
        this.owner = parent.parent;
        this.name = exported.name().length() > 1 ? exported.name() : name;
        this.type = type;
        int v = exported.visibility();
        if (v == 0) {
            v = parent.defaultVisibility;
        }
        this.visibility = v;
        this.inline = exported.inline();
        this.merge = exported.merge();
        this.skipNull = exported.skipNull();
        String[] s = exported.verboseMap().split("/");
        this.verboseMap = s.length < 2 ? null : s;
    }

    @Override
    public int compareTo(Property that) {
        return this.name.compareTo(that.name);
    }

    public abstract Type getGenericType();

    public abstract Class getType();

    public abstract String getJavadoc();

    public void writeTo(Object object, TreePruner pruner, DataWriter writer) throws IOException {
        TreePruner child = pruner.accept(object, this);
        if (child == null) {
            return;
        }
        Object d = writer.getExportConfig().getExportInterceptor().getValue(this, object, writer.getExportConfig());
        if (d == null && this.skipNull || d == ExportInterceptor.SKIP) {
            return;
        }
        if (this.merge) {
            if (d != null) {
                Class<?> objectType = d.getClass();
                Model<?> model = this.owner.getOrNull(objectType, this.parent.type, this.name);
                if (model == null && !writer.getExportConfig().isSkipIfFail()) {
                    throw new NotExportableException(objectType);
                }
                if (model != null) {
                    model.writeNestedObjectTo(d, new FilteringTreePruner(this.parent.HAS_PROPERTY_NAME_IN_ANCESTORY, child), writer);
                }
            }
        } else {
            writer.name(this.name);
            this.writeValue(this.type, d, child, writer);
        }
    }

    public void writeTo(Object object, int depth, DataWriter writer) throws IOException {
        this.writeTo(object, new TreePruner.ByDepth(depth), writer);
    }

    private void writeValue(Type expected, Object value, TreePruner pruner, DataWriter writer) throws IOException {
        this.writeValue(expected, value, pruner, writer, writer.getExportConfig().isSkipIfFail());
    }

    private void writeBuffered(Type expected, Object value, TreePruner pruner, DataWriter writer) throws IOException {
        BufferedDataWriter buffer;
        block2: {
            buffer = new BufferedDataWriter(writer.getExportConfig());
            try {
                this.writeValue(expected, value, pruner, buffer, true);
                buffer.finished();
            }
            catch (IOException x) {
                if (!(x.getCause() instanceof InvocationTargetException)) break block2;
                LOGGER.log(Level.WARNING, "skipping export of " + value, x);
            }
        }
        buffer.commit(writer);
    }

    private void writeValue(Type expected, Object value, TreePruner pruner, DataWriter writer, boolean skipIfFail) throws IOException {
        if (value == null) {
            writer.valueNull();
            return;
        }
        if (value instanceof CustomExportedBean) {
            this.writeValue(expected, ((CustomExportedBean)value).toExportedObject(), pruner, writer);
            return;
        }
        Class<?> c = value.getClass();
        Model<?> model = this.owner.getOrNull(c, this.parent.type, this.name);
        if (model == null) {
            if (STRING_TYPES.contains(c)) {
                writer.value(value.toString());
                return;
            }
            if (PRIMITIVE_TYPES.contains(c)) {
                writer.valuePrimitive(value);
                return;
            }
            Class<?> act = c.getComponentType();
            if (act != null) {
                Range r = pruner.getRange();
                writer.startArray();
                if (value instanceof Object[]) {
                    for (Object item : r.apply((Object[])value)) {
                        this.writeBuffered(act, item, pruner, writer);
                    }
                } else {
                    int len = Math.min(r.max, Array.getLength(value));
                    for (int i = r.min; i < len; ++i) {
                        this.writeBuffered(act, Array.get(value, i), pruner, writer);
                    }
                }
                writer.endArray();
                return;
            }
            if (value instanceof Iterable) {
                writer.startArray();
                Type expectedItemType = Types.getTypeArgument((Type)expected, (int)0, null);
                for (Object item : pruner.getRange().apply((Iterable)value)) {
                    this.writeBuffered(expectedItemType, item, pruner, writer);
                }
                writer.endArray();
                return;
            }
            if (value instanceof Map) {
                if (this.verboseMap != null) {
                    writer.startArray();
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        BufferedDataWriter buffer;
                        block25: {
                            buffer = new BufferedDataWriter(writer.getExportConfig());
                            try {
                                this.writeStartObjectNullType(buffer);
                                buffer.name(this.verboseMap[0]);
                                this.writeValue(null, e.getKey(), pruner, buffer);
                                buffer.name(this.verboseMap[1]);
                                this.writeValue(null, e.getValue(), pruner, buffer);
                                buffer.endObject();
                                buffer.finished();
                            }
                            catch (IOException x) {
                                if (!(x.getCause() instanceof InvocationTargetException)) break block25;
                                LOGGER.log(Level.WARNING, "skipping export of " + e, x);
                            }
                        }
                        buffer.commit(writer);
                    }
                    writer.endArray();
                } else {
                    this.writeStartObjectNullType(writer);
                    for (Map.Entry e : ((Map)value).entrySet()) {
                        BufferedDataWriter buffer;
                        block26: {
                            buffer = new BufferedDataWriter(writer.getExportConfig());
                            try {
                                buffer.name(e.getKey().toString());
                                this.writeValue(null, e.getValue(), pruner, buffer);
                                buffer.finished();
                            }
                            catch (IOException x) {
                                if (!(x.getCause() instanceof InvocationTargetException)) break block26;
                                LOGGER.log(Level.WARNING, "skipping export of " + e, x);
                            }
                        }
                        buffer.commit(writer);
                    }
                    writer.endObject();
                }
                return;
            }
            if (value instanceof Date) {
                writer.valuePrimitive(((Date)value).getTime());
                return;
            }
            if (value instanceof Calendar) {
                writer.valuePrimitive(((Calendar)value).getTimeInMillis());
                return;
            }
            if (value instanceof Enum) {
                writer.value(value.toString());
                return;
            }
            if (skipIfFail) {
                writer.startObject();
                writer.endObject();
                return;
            }
            throw new NotExportableException(c);
        }
        writer.type(expected, value.getClass());
        writer.startObject();
        model.writeNestedObjectTo(value, pruner, writer);
        writer.endObject();
    }

    private void writeStartObjectNullType(DataWriter writer) throws IOException {
        try {
            writer.type(null, null);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        writer.startObject();
    }

    public abstract Object getValue(Object var1) throws IllegalAccessException, InvocationTargetException;

    private static class BufferedDataWriter
    implements DataWriter {
        private final ExportConfig exportConfig;
        final List<Step> steps = new ArrayList<Step>();
        boolean finished = false;

        private BufferedDataWriter(ExportConfig exportConfig) {
            this.exportConfig = exportConfig;
        }

        @Override
        @NonNull
        public ExportConfig getExportConfig() {
            return this.exportConfig;
        }

        @Override
        public void name(String name) throws IOException {
            this.steps.add(new Step(Op.name, name));
        }

        @Override
        public void valuePrimitive(Object v) throws IOException {
            this.steps.add(new Step(Op.valuePrimitive, v));
        }

        @Override
        public void value(String v) throws IOException {
            this.steps.add(new Step(Op.value, v));
        }

        @Override
        public void valueNull() throws IOException {
            this.steps.add(new Step(Op.valueNull, new Object[0]));
        }

        @Override
        public void startArray() throws IOException {
            this.steps.add(new Step(Op.startArray, new Object[0]));
        }

        @Override
        public void endArray() throws IOException {
            this.steps.add(new Step(Op.endArray, new Object[0]));
        }

        public void type(Type expected, Class actual) throws IOException {
            this.steps.add(new Step(Op.type, expected, actual));
        }

        @Override
        public void startObject() throws IOException {
            this.steps.add(new Step(Op.startObject, new Object[0]));
        }

        @Override
        public void endObject() throws IOException {
            this.steps.add(new Step(Op.endObject, new Object[0]));
        }

        private void finished() {
            this.finished = true;
        }

        void commit(DataWriter w) throws IOException {
            if (!this.finished) {
                return;
            }
            block13: for (Step step : this.steps) {
                switch (step.op) {
                    case name: {
                        w.name((String)step.args[0]);
                        continue block13;
                    }
                    case valuePrimitive: {
                        w.valuePrimitive(step.args[0]);
                        continue block13;
                    }
                    case value: {
                        w.value((String)step.args[0]);
                        continue block13;
                    }
                    case valueNull: {
                        w.valueNull();
                        continue block13;
                    }
                    case startArray: {
                        w.startArray();
                        continue block13;
                    }
                    case endArray: {
                        w.endArray();
                        continue block13;
                    }
                    case type: {
                        try {
                            w.type((Type)step.args[0], (Class)step.args[1]);
                        }
                        catch (AbstractMethodError abstractMethodError) {}
                        continue block13;
                    }
                    case startObject: {
                        w.startObject();
                        continue block13;
                    }
                    case endObject: {
                        w.endObject();
                        continue block13;
                    }
                }
                throw new AssertionError();
            }
        }

        static class Step {
            final Op op;
            final Object[] args;

            Step(Op op, Object ... args) {
                this.op = op;
                this.args = args;
            }
        }

        static enum Op {
            name,
            valuePrimitive,
            value,
            valueNull,
            startArray,
            endArray,
            type,
            startObject,
            endObject;

        }
    }
}

