/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model.BbCloudRepo;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbBranch;

public class BbCloudBranch
extends BbBranch {
    private final String name;
    private final String commitId;
    private final boolean defaultBranch;

    @JsonCreator
    public BbCloudBranch(@JsonProperty(value="name") @NonNull String name, @JsonProperty(value="target") @NonNull Target target) {
        this.name = name;
        this.commitId = target.hash;
        this.defaultBranch = target.repo.getDefaultBranch().equals(name);
    }

    @Override
    public String getLatestCommit() {
        return this.commitId;
    }

    @Override
    public boolean isDefault() {
        return this.defaultBranch;
    }

    @Override
    public String getDisplayId() {
        return this.name;
    }

    public static class Target {
        private final String hash;
        private final BbCloudRepo repo;

        @JsonCreator
        public Target(@JsonProperty(value="hash") @NonNull String hash, @JsonProperty(value="repository") @NonNull BbCloudRepo repo) {
            this.hash = hash;
            this.repo = repo;
        }
    }
}

