/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job.AbstractUserCauseRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util.UserSelector;
import hudson.Extension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartedByUserRestriction
extends AbstractUserCauseRestriction {
    private final List<UserSelector> usersList;
    @Deprecated
    private final boolean acceptAutomaticRuns;
    private final boolean acceptAnonymousUsers;
    private transient Set<String> acceptedUsers = null;

    @DataBoundConstructor
    public StartedByUserRestriction(List<UserSelector> usersList, boolean checkUpstreamProjects, boolean acceptAutomaticRuns, boolean acceptAnonymousUsers) {
        super(checkUpstreamProjects);
        this.usersList = usersList;
        this.acceptAutomaticRuns = acceptAutomaticRuns;
        this.acceptAnonymousUsers = acceptAnonymousUsers;
    }

    public List<UserSelector> getUsersList() {
        return this.usersList;
    }

    @Deprecated
    public boolean isAcceptAutomaticRuns() {
        return this.acceptAutomaticRuns;
    }

    public boolean isAcceptAnonymousUsers() {
        return this.acceptAnonymousUsers;
    }

    @Nonnull
    private synchronized Set<String> getAcceptedUsers() {
        if (this.acceptedUsers == null) {
            List<UserSelector> selectors = this.getUsersList();
            this.acceptedUsers = new HashSet<String>(selectors.size());
            for (UserSelector selector : selectors) {
                this.acceptedUsers.add(selector.getSelectedUserId());
            }
        }
        return this.acceptedUsers;
    }

    @Override
    protected boolean acceptsUser(@CheckForNull String userId) {
        return userId == null ? this.acceptAnonymousUsers : this.getAcceptedUsers().contains(userId);
    }

    @Extension
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.restrictions_Job_StartedByUserRestriction_displayName();
        }
    }
}

