/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job.AbstractUserCauseRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util.GroupSelector;
import hudson.model.User;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class StartedByMemberOfGroupRestriction
extends AbstractUserCauseRestriction {
    private final List<GroupSelector> groupList;
    private transient Set<String> acceptedGroups = null;

    @DataBoundConstructor
    public StartedByMemberOfGroupRestriction(List<GroupSelector> groupList, boolean checkUpstreamProjects) {
        super(checkUpstreamProjects);
        this.groupList = groupList;
    }

    public List<GroupSelector> getGroupList() {
        return this.groupList;
    }

    @Nonnull
    private synchronized Set<String> getAcceptedGroups() {
        if (this.acceptedGroups == null) {
            List selectors = this.getGroupList();
            this.acceptedGroups = new HashSet(selectors.size());
            for (GroupSelector selector : selectors) {
                this.acceptedGroups.add(selector.getSelectedGroupId());
            }
        }
        return this.acceptedGroups;
    }

    protected boolean acceptsUser(@CheckForNull String userId) {
        if (userId == null) {
            return false;
        }
        List authorities = StartedByMemberOfGroupRestriction.getAuthorities((String)userId);
        if (authorities == null) {
            return false;
        }
        Set allowedGroups = this.getAcceptedGroups();
        for (String groupId : authorities) {
            if (!allowedGroups.contains(groupId)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static List<String> getAuthorities(@Nonnull String userId) {
        User usr = User.get((String)userId, (boolean)false, null);
        if (usr == null) {
            return StartedByMemberOfGroupRestriction.getAuthoritiesFromRealm((String)userId);
        }
        List authorities = usr.getAuthorities();
        if (authorities.isEmpty()) {
            return StartedByMemberOfGroupRestriction.getAuthoritiesFromRealm((String)userId);
        }
        return authorities;
    }

    @CheckForNull
    private static List<String> getAuthoritiesFromRealm(@Nonnull String userId) {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        UserDetails userDetails = null;
        try {
            SecurityRealm sr = instance.getSecurityRealm();
            userDetails = sr.loadUserByUsername(userId);
        }
        catch (DataAccessException ex) {
        }
        catch (UsernameNotFoundException ex) {
            // empty catch block
        }
        if (userDetails == null) {
            return null;
        }
        GrantedAuthority[] authorities = userDetails.getAuthorities();
        ArrayList<String> authorityList = new ArrayList<String>(authorities.length);
        for (GrantedAuthority auth : authorities) {
            authorityList.add(auth.getAuthority());
        }
        return authorityList;
    }
}

