/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.Messages;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.EnvStringParseHelper;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.CommandInstaller;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SharedDirectoryInstaller
extends ToolInstaller {
    private final String toolHome;

    @DataBoundConstructor
    public SharedDirectoryInstaller(String label, String toolHome) {
        super(label);
        this.toolHome = toolHome;
    }

    public String getToolHome() {
        return this.toolHome;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        String substitutedHome = EnvStringParseHelper.substituteNodeVariablesValidated(this, "Tool Home", this.toolHome, node);
        FilePath dir = this.preferredLocation(tool, node);
        return dir.child(substitutedHome);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<CommandInstaller> {
        public String getDisplayName() {
            return Messages.SharedDirectoryInstaller_DescriptorImpl_displayName();
        }

        public FormValidation doCheckToolHome(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.SharedDirectoryInstaller_no_toolHome());
        }
    }
}

