/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.Messages;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.EnvStringParseHelper;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.ExtraToolInstallersException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class StubInstaller
extends ToolInstaller {
    private final String message;
    private final boolean failTheBuild;

    @DataBoundConstructor
    public StubInstaller(String label, String message, boolean failTheBuild) {
        super(label);
        this.message = Util.fixEmptyAndTrim((String)message);
        this.failTheBuild = failTheBuild;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFailTheBuild() {
        return this.failTheBuild;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath dir = this.preferredLocation(tool, node);
        String messagePrefix = "[" + tool.getName() + "] - ";
        String outMessage = messagePrefix + (this.message != null ? EnvStringParseHelper.substituteNodeVariablesValidated((ToolInstaller)this, (String)"Message", (String)this.message, (Node)node) : Messages.StubInstaller_defaultMessage());
        log.getLogger().println(outMessage);
        if (this.failTheBuild) {
            throw new ExtraToolInstallersException((ToolInstaller)this, messagePrefix + "Installation has been interrupted");
        }
        return dir;
    }
}

