/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.EnvStringParseHelper;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SharedDirectoryInstaller
extends ToolInstaller {
    private final String toolHome;

    @DataBoundConstructor
    public SharedDirectoryInstaller(String label, String toolHome) {
        super(label);
        this.toolHome = toolHome;
    }

    public String getToolHome() {
        return this.toolHome;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        String substitutedHome = EnvStringParseHelper.substituteNodeVariablesValidated((ToolInstaller)this, (String)"Tool Home", (String)this.toolHome, (Node)node);
        FilePath dir = this.preferredLocation(tool, node);
        return dir.child(substitutedHome);
    }
}

