/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.CommandInstaller;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BatchCommandInstaller
extends ToolInstaller {
    private final String command;
    private final String toolHome;

    @DataBoundConstructor
    public BatchCommandInstaller(String label, String command, String toolHome) {
        super(label);
        this.command = BatchCommandInstaller.fixCrLf(command);
        this.toolHome = toolHome;
    }

    private static String fixCrLf(String s) {
        int idx;
        while ((idx = s.indexOf("\r\n")) != -1) {
            s = s.substring(0, idx) + s.substring(idx + 1);
        }
        return s;
    }

    public String getCommand() {
        return this.command;
    }

    public String getToolHome() {
        return this.toolHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath dir = this.preferredLocation(tool, node);
        FilePath script = dir.createTextTempFile("hudson", ".bat", this.command);
        try {
            String[] cmd = new String[]{"cmd", "/c", "call", script.getRemote()};
            int r = node.createLauncher(log).launch().cmds(cmd).stdout(log).pwd(dir).join();
            if (r != 0) {
                throw new IOException("Command returned status " + r);
            }
        }
        finally {
            script.delete();
        }
        return dir.child(this.toolHome);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<CommandInstaller> {
        public String getDisplayName() {
            return Messages.BatchCommandInstaller_DescriptorImpl_displayName();
        }

        public FormValidation doCheckCommand(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BatchCommandInstaller_no_command());
        }

        public FormValidation doCheckToolHome(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BatchCommandInstaller_no_toolHome());
        }
    }
}

