/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.google.common.collect.ImmutableMap;
import com.splunk.splunkjenkins.model.EventType;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class MetaDataConfigItem
implements Describable<MetaDataConfigItem> {
    private static final String DISABLED_KEY = "disabled";
    private static final Map<String, String> CONFIG_ITEM_MAP = new ImmutableMap.Builder().put((Object)"Index", (Object)"index").put((Object)"Source Type", (Object)"sourcetype").put((Object)"Disabled", (Object)"disabled").build();
    @NonNull
    private String dataSource;
    @NonNull
    private String keyName;
    private String value;

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@NonNull String dataSource) {
        this.dataSource = dataSource;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(@NonNull String keyName) {
        this.keyName = keyName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @DataBoundConstructor
    public MetaDataConfigItem(String dataSource, String keyName, String value) {
        this.dataSource = dataSource;
        this.keyName = keyName;
        this.value = value;
    }

    public String toString() {
        Object prefix = this.dataSource.toLowerCase() + ".";
        if ("default".equals(this.dataSource)) {
            prefix = "";
        }
        if (DISABLED_KEY.equals(this.keyName)) {
            return (String)prefix + "enabled=false";
        }
        return (String)prefix + this.keyName + "=" + this.value;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MetaDataConfigItem)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public Descriptor<MetaDataConfigItem> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(MetaDataConfigItem.class);
    }

    public static Set<MetaDataConfigItem> loadProps(String properties) {
        HashSet<MetaDataConfigItem> config = new HashSet<MetaDataConfigItem>();
        if (properties != null) {
            Properties metaDataConfigProps = new Properties();
            try {
                metaDataConfigProps.load(new StringReader(properties));
                for (EventType eventType : EventType.values()) {
                    if ("false".equals(metaDataConfigProps.getProperty(eventType.getKey("enabled")))) {
                        config.add(new MetaDataConfigItem(eventType.toString(), DISABLED_KEY, ""));
                        continue;
                    }
                    for (String suffix : CONFIG_ITEM_MAP.values()) {
                        String lookupKey = eventType.getKey(suffix);
                        if (!metaDataConfigProps.containsKey(lookupKey)) continue;
                        config.add(new MetaDataConfigItem(eventType.toString(), suffix, metaDataConfigProps.getProperty(lookupKey)));
                    }
                }
                for (String keyName : CONFIG_ITEM_MAP.values()) {
                    if (!metaDataConfigProps.containsKey(keyName)) continue;
                    config.add(new MetaDataConfigItem("default", keyName, metaDataConfigProps.getProperty(keyName)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public static String toString(Set<MetaDataConfigItem> configs) {
        StringBuffer sbf = new StringBuffer();
        if (configs == null || configs.isEmpty()) {
            return "";
        }
        for (MetaDataConfigItem config : configs) {
            sbf.append(config.toString()).append("\n");
        }
        return sbf.toString();
    }

    public String getCssDisplay() {
        if (DISABLED_KEY.equals(this.keyName)) {
            return "display:none";
        }
        return "display:''";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<MetaDataConfigItem> {
        public String getDisplayName() {
            return "Metadata config";
        }

        public ListBoxModel doFillDataSourceItems() {
            ListBoxModel m = new ListBoxModel();
            m.add("Build Event", EventType.BUILD_EVENT.toString());
            m.add("Build Report", EventType.BUILD_REPORT.toString());
            m.add("Console Log", EventType.CONSOLE_LOG.toString());
            m.add("Jenkins Config", EventType.JENKINS_CONFIG.toString());
            m.add("Log File", EventType.FILE.toString());
            m.add("Queue Information", EventType.QUEUE_INFO.toString());
            m.add("Agent Information", EventType.SLAVE_INFO.toString());
            m.add("Default", "default");
            return m;
        }

        public static ListBoxModel doFillKeyNameItems() {
            ListBoxModel m = new ListBoxModel();
            for (Map.Entry<String, String> entry : CONFIG_ITEM_MAP.entrySet()) {
                m.add(entry.getKey(), entry.getValue());
            }
            return m;
        }
    }
}

