/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.HealthMonitor;
import com.splunk.splunkjenkins.JdkSplunkLogHandler;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.WebPostAccessLogger;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import jenkins.util.Timer;

@SuppressFBWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"})
public class LoggingInitStep {
    private static final String rootLoggerName = "";

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void setupSplunkJenkins() {
        Timer.get().schedule(new Runnable(){

            @Override
            public void run() {
                LoggingInitStep.registerHandler();
            }
        }, 30L, TimeUnit.SECONDS);
    }

    protected static void registerHandler() {
        Handler[] handlers;
        for (Handler handler : handlers = Logger.getLogger(rootLoggerName).getHandlers()) {
            if (!(handler instanceof JdkSplunkLogHandler)) continue;
            return;
        }
        Logger.getLogger(HealthMonitor.class.getName()).setLevel(Level.WARNING);
        Logger.getLogger(rootLoggerName).addHandler(JdkSplunkLogHandler.LogHolder.LOG_HANDLER);
        SplunkJenkinsInstallation.get().updateCache();
        SplunkJenkinsInstallation.markComplete(true);
        Logger.getLogger(LoggingInitStep.class.getName()).info("plugin splunk-devops version " + LogEventHelper.getBuildVersion() + " loaded");
        if (Constants.ENABLE_POST_LOGGER) {
            try {
                PluginServletFilter.addFilter((Filter)new WebPostAccessLogger());
            }
            catch (ServletException e) {
                Logger.getLogger(LoggingInitStep.class.getName()).warning("failed to register splunk web access logger");
            }
        }
    }
}

