/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventRecord;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.LogConsumer;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import hudson.model.Computer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jenkins.model.Jenkins;

public class JdkSplunkLogHandler
extends Handler {
    private Lock maintenanceLock = new ReentrantLock();
    private List<EventRecord> verboseLogCache = Collections.synchronizedList(new ArrayList(Constants.JDK_FINE_LOG_BATCH));
    private Level filterLevel = Level.parse(System.getProperty(JdkSplunkLogHandler.class.getName() + ".level", "INFO"));
    private LogEventFormatter splunkFormatter = new LogEventFormatter();

    public JdkSplunkLogHandler() {
        this.setFilter(new LogFilter());
        this.setLevel(this.filterLevel);
    }

    @Override
    public void publish(LogRecord record) {
        if (!SplunkJenkinsInstallation.isLogHandlerRegistered()) {
            return;
        }
        if (!this.isLoggable(record)) {
            return;
        }
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.CONSOLE_LOG)) {
            return;
        }
        Map logEvent = this.splunkFormatter.getEvent(record);
        if (logEvent == null || logEvent.isEmpty()) {
            return;
        }
        EventRecord logEventRecord = new EventRecord(logEvent, EventType.LOG);
        logEventRecord.setSource("logger://" + record.getLoggerName());
        if (record.getLevel().intValue() < Level.INFO.intValue()) {
            this.verboseLogCache.add(logEventRecord);
            if (this.verboseLogCache.size() >= Constants.JDK_FINE_LOG_BATCH) {
                this.flush();
            }
        } else {
            SplunkLogService.getInstance().send(logEventRecord);
        }
    }

    @Override
    public void flush() {
        if (this.verboseLogCache.isEmpty()) {
            return;
        }
        ArrayList<EventRecord> copyList = new ArrayList<EventRecord>();
        try {
            this.maintenanceLock.lock();
            copyList.addAll(this.verboseLogCache);
            this.verboseLogCache.clear();
        }
        finally {
            this.maintenanceLock.unlock();
        }
        SplunkLogService.getInstance().sendBatch(copyList, EventType.LOG);
    }

    @Override
    public void close() throws SecurityException {
    }

    private static class LogEventFormatter
    extends Formatter {
        private LogEventFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return this.formatMessage(record);
        }

        public Map getEvent(LogRecord record) {
            Object source;
            HashMap<String, Object> event = new HashMap<String, Object>();
            event.put("thread_id", record.getThreadID());
            event.put("level", record.getLevel().getName());
            event.put("message", this.formatMessage(record));
            if (record.getSourceClassName() != null) {
                source = record.getSourceClassName();
                if (record.getSourceMethodName() != null) {
                    source = (String)source + " " + record.getSourceMethodName();
                }
            } else {
                source = record.getLoggerName();
            }
            event.put("log_source", source);
            if (record.getLevel().intValue() > Level.INFO.intValue() && record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                String logStackTrace = sw.toString();
                event.put("log_thrown", logStackTrace);
            }
            return event;
        }
    }

    private static class LogFilter
    implements Filter {
        private final String[] skipLoggerNames = new String[]{SplunkLogService.class.getName(), LogConsumer.class.getName(), "jenkins.InitReactorRunner", "hudson.util.BootFailure", "shaded.splk.org.apache.http", "hudson.node_monitors", "hudson.Extension"};

        private LogFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            String logSource = record.getSourceClassName();
            String loggerName = record.getLoggerName();
            if (logSource == null || loggerName == null) {
                return false;
            }
            for (int i = 0; i < this.skipLoggerNames.length; ++i) {
                String skipPrefix = this.skipLoggerNames[i];
                if (!logSource.startsWith(skipPrefix) && !loggerName.startsWith(skipPrefix)) continue;
                return false;
            }
            if (record.getThrown() != null) {
                StackTraceElement[] cause;
                for (StackTraceElement element : cause = record.getThrown().getStackTrace()) {
                    if (!element.getClassName().equals(JdkSplunkLogHandler.class.getName())) continue;
                    SplunkLogService.LOG.log(Level.SEVERE, "discard recursive log\n{0}", record.getMessage());
                    return false;
                }
            }
            return true;
        }
    }

    public static final class LogHolder {
        static final JdkSplunkLogHandler LOG_HANDLER = new JdkSplunkLogHandler();

        public static void getSlaveLog(Computer computer) {
            if (computer == null || computer instanceof Jenkins.MasterComputer) {
                return;
            }
            try {
                List records = computer.getLogRecords();
                for (LogRecord record : records) {
                    LOG_HANDLER.publish(record);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

