/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.utils;

import com.splunk.splunkjenkins.model.AbstractTestResultAdapter;
import com.splunk.splunkjenkins.model.EmptyTestCaseGroup;
import com.splunk.splunkjenkins.model.JunitTestCaseGroup;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestCaseResultUtils {
    public static <T extends TestResult> List<JunitTestCaseGroup> split(@NonNull List<T> results, int pageSize) {
        ArrayList<JunitTestCaseGroup> testCasesCollect = new ArrayList<JunitTestCaseGroup>();
        if (results.isEmpty()) {
            return testCasesCollect;
        }
        JunitTestCaseGroup group = null;
        int count = 1;
        for (TestResult testCase : results) {
            if (count % pageSize == 1) {
                group = new JunitTestCaseGroup();
                testCasesCollect.add(group);
            }
            ++count;
            group.add(testCase);
        }
        return testCasesCollect;
    }

    public static List<JunitTestCaseGroup> splitRaw(AbstractTestResultAction resultAction, int pageSize) {
        ArrayList<JunitTestCaseGroup> testCasesCollect = new ArrayList<JunitTestCaseGroup>();
        JunitTestCaseGroup group = new JunitTestCaseGroup();
        testCasesCollect.add(group);
        ArrayList results = new ArrayList();
        results.addAll(resultAction.getFailedTests());
        results.addAll(resultAction.getSkippedTests());
        results.addAll(resultAction.getPassedTests());
        for (TestResult testCase : results) {
            group.add(testCase);
            if (group.getTotal() <= pageSize) continue;
            group = new JunitTestCaseGroup();
            testCasesCollect.add(group);
        }
        return testCasesCollect;
    }

    @NonNull
    public static List<JunitTestCaseGroup> getBuildReport(Run build, int pageSize) {
        return TestCaseResultUtils.getBuildReport(build, pageSize, null);
    }

    public static List<JunitTestCaseGroup> getBuildReport(Run build, int pageSize, List<String> ignoredTestActions) {
        AbstractTestResultAction abstractTestResultAction;
        List<TestResult> results;
        List<JunitTestCaseGroup> junitReports = new ArrayList<JunitTestCaseGroup>();
        if (build == null) {
            return junitReports;
        }
        if (ignoredTestActions == null) {
            ignoredTestActions = new ArrayList<String>();
        }
        if ((junitReports = TestCaseResultUtils.split(results = AbstractTestResultAdapter.getTestResult(build, ignoredTestActions), pageSize)).isEmpty() && (abstractTestResultAction = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class)) != null && !ignoredTestActions.contains(abstractTestResultAction.getClass().getName())) {
            junitReports = TestCaseResultUtils.splitRaw(abstractTestResultAction, pageSize);
        }
        if (junitReports.isEmpty()) {
            EmptyTestCaseGroup emptyReport = new EmptyTestCaseGroup();
            if (build.getResult() != Result.SUCCESS && (LogEventHelper.hasPublisherName("junit.JUnitResultArchiver", build) || LogEventHelper.hasPublisherName("testng.Publisher", build))) {
                emptyReport.setWarning(true);
            }
            junitReports.add(emptyReport);
        }
        return junitReports;
    }

    public static Map<String, Object> getSummary(Run build) {
        List<JunitTestCaseGroup> results = TestCaseResultUtils.getBuildReport(build, Integer.MAX_VALUE);
        HashMap<String, Object> summary = new HashMap<String, Object>();
        if (results.isEmpty()) {
            return summary;
        }
        JunitTestCaseGroup testResult = results.get(0);
        summary.put("failures", testResult.getFailures());
        summary.put("passes", testResult.getPasses());
        summary.put("skips", testResult.getSkips());
        summary.put("total", testResult.getTotal());
        summary.put("duration", Float.valueOf(testResult.getDuration()));
        return summary;
    }
}

