/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.utils;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventRecord;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import shaded.splk.org.apache.http.HttpEntity;
import shaded.splk.org.apache.http.HttpResponse;
import shaded.splk.org.apache.http.client.HttpClient;
import shaded.splk.org.apache.http.client.ResponseHandler;
import shaded.splk.org.apache.http.client.methods.HttpPost;
import shaded.splk.org.apache.http.client.methods.HttpUriRequest;
import shaded.splk.org.apache.http.util.EntityUtils;

public class LogConsumer
extends Thread {
    private static final Logger LOG = Logger.getLogger(LogConsumer.class.getName());
    private static final int retryInterval = Integer.parseInt(System.getProperty("splunk-retryinterval", "15"));
    private final HttpClient client;
    private final BlockingQueue<EventRecord> queue;
    private boolean acceptingTask = true;
    private AtomicLong outgoingCounter;
    private long errorCount;
    private boolean sending = false;
    private final int RETRY_SLEEP_THRESHOLD = 1024;
    private List<Class<? extends IOException>> giveUpExceptions = Arrays.asList(UnknownHostException.class, SSLException.class, SplunkClientError.class);
    private ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws IOException {
            int status = response.getStatusLine().getStatusCode();
            String reason = response.getStatusLine().getReasonPhrase();
            if (status == 200) {
                LogConsumer.this.outgoingCounter.incrementAndGet();
                HttpEntity entity = response.getEntity();
                return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            }
            ++LogConsumer.this.errorCount;
            if (status == 503) {
                throw new SplunkServiceError("Server is busy, maybe caused by blocked queue, please check https://wiki.splunk.com/Community:TroubleshootingBlockedQueues", status);
            }
            Object message = status == 403 || status == 401 ? reason + ", http event collector token is invalid" : (status == 400 ? reason + ", incorrect index or invalid data format" : reason);
            throw new SplunkClientError((String)message, status);
        }
    };

    public LogConsumer(HttpClient client, BlockingQueue<EventRecord> queue, AtomicLong counter) {
        this.client = client;
        this.queue = queue;
        this.errorCount = 0L;
        this.outgoingCounter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.acceptingTask) {
            try {
                EventRecord record = this.queue.take();
                HttpPost post = null;
                try {
                    this.sending = true;
                    post = LogEventHelper.buildPost(record, SplunkJenkinsInstallation.get());
                    this.client.execute((HttpUriRequest)post, this.responseHandler);
                }
                catch (IOException ex) {
                    boolean isDiscarded = false;
                    for (Class<? extends IOException> giveUpException : this.giveUpExceptions) {
                        if (!giveUpException.isInstance(ex)) continue;
                        isDiscarded = true;
                        LOG.log(Level.SEVERE, "message not delivered:" + record.getShortDescription(), ex);
                        break;
                    }
                    if (isDiscarded) continue;
                    this.handleRetry(ex, record);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "failed construct post message" + record.getShortDescription(), e);
                }
                finally {
                    this.sending = false;
                    if (post == null) continue;
                    post.releaseConnection();
                }
            }
            catch (InterruptedException e) {
                ++this.errorCount;
            }
            catch (Throwable ex) {
                ++this.errorCount;
                LOG.log(Level.SEVERE, "get exception in worker thread", ex);
            }
        }
    }

    private void handleRetry(IOException ex, EventRecord record) throws InterruptedException {
        if (ex instanceof SplunkServiceError) {
            int sleepTime = 2 * retryInterval;
            LOG.log(Level.WARNING, "{0}, will wait {1} seconds and retry", new Object[]{ex.getMessage(), sleepTime});
            this.retry(record, sleepTime);
        } else if (ex instanceof ConnectException) {
            LOG.log(Level.WARNING, "{0} connect error, will wait {1} seconds and retry", new Object[]{this.getName(), retryInterval});
            this.retry(record, retryInterval);
        } else {
            LOG.log(Level.WARNING, "will resend the message:{0}", record.getShortDescription());
            this.retry(record, 1);
        }
    }

    public void stopTask() {
        this.acceptingTask = false;
        for (int i = 0; i < 5; ++i) {
            if (!this.sending) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if (this.isAlive()) {
            this.interrupt();
        }
    }

    private void retry(EventRecord record, int sleepIntervalInSeconds) throws InterruptedException {
        record.increase();
        if (record.isDiscarded()) {
            LOG.log(Level.SEVERE, "discarded " + record.getShortDescription());
            return;
        }
        if (this.acceptingTask) {
            if (this.queue.size() < 1024) {
                Thread.sleep(sleepIntervalInSeconds * 1000);
            }
            SplunkLogService.getInstance().enqueue(record);
        }
    }

    @Override
    public String toString() {
        return "LogConsumer{ errors=" + this.errorCount + ", name=" + this.getName() + " }";
    }

    public static class SplunkClientError
    extends IOException {
        int status;

        public SplunkClientError(String message, int status) {
            super(message + ", status code:" + status);
            this.status = status;
        }
    }

    public static class SplunkServiceError
    extends IOException {
        public SplunkServiceError(String message, int status) {
            super(message);
        }
    }
}

