/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.model.AbstractTestResultAdapter;
import com.splunk.splunkjenkins.model.TestCaseResult;
import com.splunk.splunkjenkins.model.TestStatus;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import hudson.plugins.testng.TestNGTestResultBuildAction;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.TestNGTestResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.ArrayList;
import java.util.List;

@Extension(optional=true)
public class TestNGResultAdapter
extends AbstractTestResultAdapter<TestNGTestResultBuildAction> {
    @Override
    public List<TestCaseResult> getTestResult(TestNGTestResultBuildAction resultAction) {
        String buildUrl = "";
        if (resultAction.run != null) {
            buildUrl = resultAction.run.getUrl();
        }
        List testResults = resultAction.getResult().getTestList();
        ArrayList<TestCaseResult> caseResults = new ArrayList<TestCaseResult>();
        for (TestNGTestResult testResult : testResults) {
            for (ClassResult classResult : testResult.getClassList()) {
                for (MethodResult methodResult : classResult.getTestMethods()) {
                    String status;
                    TestCaseResult testCaseResult = new TestCaseResult();
                    testCaseResult.setTestName(methodResult.getName());
                    testCaseResult.setUniqueName(methodResult.getSafeName());
                    testCaseResult.setDuration(methodResult.getDuration());
                    testCaseResult.setClassName(methodResult.getClassName());
                    testCaseResult.setGroupName(testResult.getName());
                    switch (status = Util.fixNull((String)methodResult.getStatus()).toLowerCase()) {
                        case "fail": {
                            MethodResultException exception = methodResult.getException();
                            if (exception != null) {
                                if (exception.getMessage() != null) {
                                    testCaseResult.setErrorDetails(exception.getMessage());
                                } else {
                                    testCaseResult.setErrorDetails(exception.getExceptionName());
                                }
                            } else {
                                testCaseResult.setErrorDetails("(none)");
                            }
                            testCaseResult.setErrorStackTrace(methodResult.getErrorStackTrace());
                            Run run = methodResult.getRun();
                            if (run != null) {
                                int failedSince = this.getFailedSince(run, methodResult.getId());
                                testCaseResult.setFailedSince(failedSince);
                            }
                            testCaseResult.setStatus(TestStatus.FAILURE);
                            break;
                        }
                        case "skip": {
                            testCaseResult.setSkipped(true);
                            testCaseResult.setStatus(TestStatus.SKIPPED);
                            break;
                        }
                        case "pass": {
                            testCaseResult.setStatus(TestStatus.PASSED);
                            break;
                        }
                        default: {
                            testCaseResult.setStatus(TestStatus.PASSED);
                        }
                    }
                    testCaseResult.setSkippedMessage(methodResult.getDescription());
                    testCaseResult.setStdout(methodResult.getReporterOutput());
                    testCaseResult.setStdout(TestNGResultAdapter.trimToLimit(methodResult.getReporterOutput(), methodResult.getSafeName(), buildUrl));
                    caseResults.add(testCaseResult);
                }
            }
        }
        return caseResults;
    }

    private int getFailedSince(Run b, String id) {
        int i = 0;
        int buildNumber = 0;
        while (i++ < 20) {
            buildNumber = b.getNumber();
            if ((b = b.getPreviousBuild()) == null) {
                return buildNumber;
            }
            AbstractTestResultAction r = (AbstractTestResultAction)b.getAction(this.targetType);
            if (r != null) {
                MethodResult result = (MethodResult)r.findCorrespondingResult(id);
                if (result != null && "fail".equalsIgnoreCase(result.getStatus())) continue;
                return buildNumber;
            }
            return buildNumber;
        }
        return buildNumber;
    }
}

