/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.model;

import com.splunk.splunkjenkins.Constants;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.tiger_types.Types;

public abstract class AbstractTestResultAdapter<A extends AbstractTestResultAction>
implements ExtensionPoint {
    private static final Logger LOG = Logger.getLogger(AbstractTestResultAdapter.class.getName());
    public final Class<A> targetType;

    public AbstractTestResultAdapter() {
        Type type = Types.getBaseClass(this.getClass(), AbstractTestResultAdapter.class);
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException(String.valueOf(this.getClass()) + " uses the raw type for extending AbstractTestResultAdapter");
        }
        this.targetType = Types.erasure((Type)Types.getTypeArgument((Type)type, (int)0));
    }

    public A getAction(Run run) {
        return (A)((AbstractTestResultAction)run.getAction(this.targetType));
    }

    public boolean isApplicable(Run build) {
        return this.getAction(build) != null;
    }

    @NonNull
    public static List<TestResult> getTestResult(Run build) {
        return AbstractTestResultAdapter.getTestResult(build, Collections.emptyList());
    }

    @NonNull
    public static List<TestResult> getTestResult(Run build, @NonNull List<String> ignoredActions) {
        ExtensionList adapters = ExtensionList.lookup(AbstractTestResultAdapter.class);
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (AbstractTestResultAdapter adapter : adapters) {
            Object action;
            if (!adapter.isApplicable(build) || ignoredActions.contains((action = adapter.getAction(build)).getClass().getName())) continue;
            testResults.addAll(adapter.getTestResult(action));
        }
        return testResults;
    }

    public abstract <T extends TestResult> List<T> getTestResult(A var1);

    public static String trimToLimit(String message, String caseName, String url) {
        String truncatedMessage = "...truncated";
        if (Constants.MAX_JUNIT_STDIO_SIZE < truncatedMessage.length() || message == null || message.length() <= Constants.MAX_JUNIT_STDIO_SIZE) {
            return message;
        }
        LOG.log(Level.WARNING, "build_url={0} testcase={1} message=\"stdout or stderr too large\" length={2,number,#} truncated_size={3,number,#}\nplease adjust jenkins startup option -Dsplunkins.junitStdioLimit=x if you want to avoid this", new Object[]{url, caseName, message.length(), Constants.MAX_JUNIT_STDIO_SIZE});
        return message.substring(0, Constants.MAX_JUNIT_STDIO_SIZE - truncatedMessage.length()) + truncatedMessage;
    }
}

