/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.listeners;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.UserActionDSL;
import com.splunk.splunkjenkins.listeners.LoggingQueueListener;
import com.splunk.splunkjenkins.listeners.Messages;
import com.splunk.splunkjenkins.model.CoverageMetricsAdapter;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.model.LoggingJobExtractor;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import com.splunk.splunkjenkins.utils.TestCaseResultUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Describable;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import org.apache.commons.lang3.StringUtils;

@Extension
public class LoggingRunListener
extends RunListener<Run> {
    private static final Logger LOG = Logger.getLogger(LoggingRunListener.class.getName());
    private final String NODE_NAME_KEY = "node";
    UserActionDSL postJobAction = new UserActionDSL();

    public void onStarted(Run run, TaskListener listener) {
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.BUILD_EVENT) || SplunkJenkinsInstallation.get().isJobIgnored(run.getUrl())) {
            return;
        }
        Map<String, Object> event = this.getCommonBuildInfo(run, false);
        event.put("type", "started");
        String sourceName = SplunkJenkinsInstallation.get().getMetadataSource() + "/job_event";
        SplunkLogService.getInstance().send(event, EventType.BUILD_EVENT, sourceName);
        if (event.get("user") != null) {
            LogEventHelper.logUserAction((String)event.get("user"), Messages.audit_start_job(event.get("build_url")));
        }
        LogEventHelper.updateSlaveInfoAsync((String)event.get("node"));
    }

    public void onCompleted(Run run, @NonNull TaskListener listener) {
        AbstractBuild build;
        List<String> changelog;
        Map<CoverageMetricsAdapter.Metric, Integer> coverage;
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.BUILD_EVENT) || SplunkJenkinsInstallation.get().isJobIgnored(run.getUrl())) {
            return;
        }
        Map<String, Object> event = this.getCommonBuildInfo(run, true);
        event.put("type", "completed");
        float duration = LogEventHelper.getRunDuration(run);
        event.put("job_duration", Float.valueOf(duration));
        event.put("job_result", String.valueOf(run.getResult()));
        Map<String, Object> testSummary = TestCaseResultUtils.getSummary(run);
        if (!testSummary.isEmpty()) {
            event.put("test_summary", testSummary);
        }
        if (!(coverage = CoverageMetricsAdapter.getMetrics(run)).isEmpty()) {
            event.put("coverage", coverage);
        }
        LogEventHelper.appendScm(event, run);
        if (run instanceof AbstractBuild && !(changelog = this.getChangeLog(build = (AbstractBuild)run)).isEmpty()) {
            event.put("changelog", changelog);
        }
        String sourceName = SplunkJenkinsInstallation.get().getMetadataSource("job_event");
        SplunkLogService.getInstance().send(event, EventType.BUILD_EVENT, sourceName);
        this.postJobAction.perform(run, listener, SplunkJenkinsInstallation.get().getCode());
        if (run.getExecutor() != null) {
            LogEventHelper.updateSlaveInfoAsync((String)event.get("node"));
        }
        LoggingQueueListener.expire(run.getQueueId());
        this.recordAbortAction(run);
    }

    private String getUpStreamURL(Run run) {
        for (CauseAction action : run.getActions(CauseAction.class)) {
            Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)action.findCause(Cause.UpstreamCause.class);
            if (upstreamCause == null) continue;
            return this.getUpStreamCauseURL(upstreamCause);
        }
        return "";
    }

    private String getUpStreamCauseURL(Cause.UpstreamCause upstreamCause) {
        if (upstreamCause == null) {
            return "";
        }
        for (Cause upCause : upstreamCause.getUpstreamCauses()) {
            if (!(upCause instanceof Cause.UpstreamCause)) continue;
            return this.getUpStreamCauseURL((Cause.UpstreamCause)upCause);
        }
        return upstreamCause.getUpstreamUrl() + upstreamCause.getUpstreamBuild() + "/";
    }

    private Map<String, Object> getCommonBuildInfo(Run run, boolean completed) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("event_tag", "job_event");
        event.put("build_number", run.getNumber());
        event.put("trigger_by", LogEventHelper.getBuildCauses(run));
        event.put("user", LogEventHelper.getTriggerUserName(run));
        long queueId = run.getQueueId();
        Float queueTime = LoggingQueueListener.getQueueTime(queueId);
        event.put("queue_time", queueTime);
        event.put("queue_id", queueId);
        event.put("build_url", run.getUrl());
        event.put("upstream", this.getUpStreamURL(run));
        event.put("job_started_at", run.getTimestampString2());
        event.put("job_name", run.getParent().getFullName());
        Map<String, Object> parameters = LogEventHelper.getBuildVariables(run, completed);
        if (!parameters.isEmpty()) {
            event.put("metadata", parameters);
        }
        if (run.getParent() instanceof Describable) {
            String jobType = ((Describable)run.getParent()).getDescriptor().getDisplayName();
            event.put("job_type", jobType);
        }
        Executor executor = run.getExecutor();
        String nodeName = "";
        String label = null;
        if (executor != null) {
            Node execNode = executor.getOwner().getNode();
            if (execNode != null) {
                label = execNode.getLabelString();
            }
            if (StringUtils.isEmpty((CharSequence)(nodeName = executor.getOwner().getName()))) {
                nodeName = "(built-in)";
            }
        } else if (run instanceof AbstractBuild) {
            nodeName = ((AbstractBuild)run).getBuiltOnStr();
        }
        event.put("label", label);
        event.put("node", nodeName);
        for (LoggingJobExtractor extendListener : LoggingJobExtractor.canApply(run)) {
            try {
                Map<String, Object> extend = extendListener.extract(run, completed);
                if (extend == null || extend.isEmpty()) continue;
                event.putAll(extend);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "failed to extract job info", e);
            }
        }
        return event;
    }

    private void recordAbortAction(Run run) {
        List actions = run.getActions(InterruptedBuildAction.class);
        for (InterruptedBuildAction action : actions) {
            User user;
            List interrupts = Util.filter((List)action.getCauses(), CauseOfInterruption.UserInterruption.class);
            if (interrupts.isEmpty() || (user = ((CauseOfInterruption.UserInterruption)interrupts.get(0)).getUser()) == null) continue;
            LogEventHelper.logUserAction(user.getFullName(), Messages.audit_abort_job(run.getUrl()));
            break;
        }
    }

    private List<String> getChangeLog(AbstractBuild build) {
        ArrayList<String> changelog = new ArrayList<String>();
        if (build.hasChangeSetComputed()) {
            ChangeLogSet changeset = build.getChangeSet();
            for (ChangeLogSet.Entry entry : changeset) {
                StringBuilder sbr = new StringBuilder();
                sbr.append(entry.getTimestamp());
                sbr.append("    ").append("commit:").append(entry.getCommitId());
                sbr.append("    ").append("author:").append(entry.getAuthor());
                sbr.append("    ").append("message:").append(entry.getMsg());
                changelog.add(sbr.toString());
            }
        }
        return changelog;
    }
}

