/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.listeners;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.Map;

@Extension
public class LoggingComputerListener
extends ComputerListener {
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        this.updateStatus(c, "Online");
        listener.getLogger().flush();
    }

    public void onOffline(@NonNull Computer c, @CheckForNull OfflineCause cause) {
        this.updateStatus(c, "Offline");
    }

    public void onTemporarilyOnline(Computer c) {
        this.updateStatus(c, "Temporarily Online");
    }

    public void onTemporarilyOffline(Computer c, OfflineCause cause) {
        this.updateStatus(c, "Temporarily Offline");
    }

    public void onLaunchFailure(Computer c, TaskListener taskListener) throws IOException, InterruptedException {
        this.updateStatus(c, "Launch Failure");
        taskListener.getLogger().flush();
    }

    private void updateStatus(Computer c, String eventSource) {
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.SLAVE_INFO)) {
            return;
        }
        Map<String, Object> slaveInfo = LogEventHelper.getComputerStatus(c);
        slaveInfo.put("event_src", eventSource);
        SplunkLogService.getInstance().send(slaveInfo, EventType.SLAVE_INFO);
    }
}

