/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.console;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.console.SplunkConsoleTaskListenerDecorator;
import com.splunk.splunkjenkins.model.EventType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Queue;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;

@Extension(optional=true)
public class SplunkTaskListenerFactory
implements TaskListenerDecorator.Factory {
    private static final Logger LOGGER = Logger.getLogger(SplunkConsoleTaskListenerDecorator.class.getName());
    private static final transient LoadingCache<WorkflowRun, SplunkConsoleTaskListenerDecorator> cachedDecorator = CacheBuilder.newBuilder().weakKeys().maximumSize(1024L).build((CacheLoader)new CacheLoader<WorkflowRun, SplunkConsoleTaskListenerDecorator>(){

        public SplunkConsoleTaskListenerDecorator load(WorkflowRun key) {
            return new SplunkConsoleTaskListenerDecorator(key);
        }
    });

    public boolean isAppliedBeforeMainDecorator() {
        return true;
    }

    @CheckForNull
    public TaskListenerDecorator of(@NonNull FlowExecutionOwner flowExecutionOwner) {
        if (!SplunkJenkinsInstallation.get().isPipelineFilterEnabled()) {
            return null;
        }
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.CONSOLE_LOG)) {
            return null;
        }
        try {
            Queue.Executable executable = flowExecutionOwner.getExecutable();
            if (executable instanceof WorkflowRun) {
                WorkflowRun run = (WorkflowRun)executable;
                if (SplunkJenkinsInstallation.get().isJobIgnored(run.getUrl())) {
                    return null;
                }
                return (TaskListenerDecorator)cachedDecorator.get((Object)run);
            }
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        catch (ExecutionException e) {
            LOGGER.finer("failed to load cached decorator");
        }
        return null;
    }

    public static void removeCache(WorkflowRun run) {
        cachedDecorator.invalidate((Object)run);
    }
}

