/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.console;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.console.LabelMarkupText;
import com.splunk.splunkjenkins.utils.PlainTextConsoleUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.MarkupText;
import hudson.console.ConsoleNote;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineConsoleDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(PipelineConsoleDecoder.class.getName());
    private transient WorkflowRun run;
    private transient LabelMarkupText markupText = new LabelMarkupText();
    private boolean parseLabelFlag = Constants.DECODE_PIPELINE_CONSOLE;

    public PipelineConsoleDecoder(WorkflowRun run) {
        this.run = run;
        if (run == null) {
            this.parseLabelFlag = false;
        }
    }

    @CheckForNull
    public String decodeLine(byte[] in, int length) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (this.parseLabelFlag) {
                this.decodeConsoleObjectStream(in, length, bout);
            } else {
                PlainTextConsoleUtils.decodeConsole((byte[])in, (int)length, (ByteArrayOutputStream)bout);
            }
            return bout.toString("UTF-8");
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "failed to decode log" + String.valueOf(ex));
            return null;
        }
    }

    private void decodeConsoleObjectStream(byte[] in, int length, ByteArrayOutputStream out) throws IOException {
        int next = PlainTextConsoleUtils.arrayIndexOf((byte[])in, (int)0, (int)length, (byte[])ConsoleNote.PREAMBLE);
        int written = 0;
        while (next >= 0) {
            if (next > written) {
                out.write(in, written, next - written);
                written = next;
            }
            int rest = length - next;
            ByteArrayInputStream b = new ByteArrayInputStream(in, next, rest);
            try {
                ConsoleNote consoleNote = ConsoleNote.readFrom((DataInputStream)new DataInputStream(b));
                consoleNote.annotate((Object)this.run, (MarkupText)this.markupText, 0);
                this.markupText.write(out);
            }
            catch (IOException | ClassNotFoundException ex) {
                LOG.log(Level.WARNING, "failed to decode console note", ex);
            }
            int bytesUsed = rest - b.available();
            next = PlainTextConsoleUtils.arrayIndexOf((byte[])in, (int)(written += bytesUsed), (int)length, (byte[])ConsoleNote.PREAMBLE);
        }
        if (length - written > 0) {
            this.markupText.writePreviousLabel(out);
            out.write(in, written, length - written);
        }
    }
}

