/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.google.common.collect.ImmutableSet;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.console.ConsoleRecordCacheUtils;
import com.splunk.splunkjenkins.console.SplunkConsoleTaskListenerDecorator;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class SplunkConsoleLogStep
extends Step {
    private static final Logger LOG = Logger.getLogger(SplunkConsoleLogStep.class.getName());

    @DataBoundConstructor
    public SplunkConsoleLogStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ConsoleLogExecutionImpl(context);
    }

    public static class ConsoleLogExecutionImpl
    extends StepExecution {
        public ConsoleLogExecutionImpl(StepContext context) {
            super(context);
        }

        public boolean start() throws Exception {
            StepContext context = this.getContext();
            Run run = (Run)context.get(Run.class);
            BodyInvoker invoker = context.newBodyInvoker().withCallback((BodyExecutionCallback)new BodyExecutionCallbackConsole());
            if (!SplunkJenkinsInstallation.get().isPipelineFilterEnabled()) {
                invoker.withContext((Object)TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)context.get(TaskListenerDecorator.class)), (TaskListenerDecorator)new SplunkConsoleTaskListenerDecorator((WorkflowRun)run)));
            } else {
                String jobName = run.getParent().getFullName();
                LOG.log(Level.INFO, "ignored sendSplunkConsoleLog since global filter is enabled, job-name=" + jobName);
            }
            invoker.start();
            return false;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            this.getContext().onFailure(cause);
        }
    }

    public static class BodyExecutionCallbackConsole
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;

        protected void finished(StepContext stepContext) throws Exception {
            ConsoleRecordCacheUtils.flushLog();
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class);
        }

        public String getFunctionName() {
            return "sendSplunkConsoleLog";
        }

        @NonNull
        public String getDisplayName() {
            return "Send console log Splunk";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }
}

