/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.google.common.collect.ImmutableSet;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SplunkLogFileStep
extends Step {
    String includes;
    @DataBoundSetter
    String sizeLimit;
    @DataBoundSetter
    String excludes;
    @DataBoundSetter
    boolean publishFromSlave;

    @DataBoundConstructor
    public SplunkLogFileStep(@NonNull String includes) {
        this.includes = includes;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SplunkLogFileStepExecution(context, this);
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public boolean isPublishFromSlave() {
        return this.publishFromSlave;
    }

    public void setPublishFromSlave(boolean publishFromSlave) {
        this.publishFromSlave = publishFromSlave;
    }

    public String getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(String sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public static class SplunkLogFileStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1152009261375345133L;
        private transient SplunkLogFileStep step;

        protected SplunkLogFileStepExecution(StepContext context, SplunkLogFileStep step) throws Exception {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            if (!SplunkJenkinsInstallation.get().isEnabled()) {
                return null;
            }
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            Run build = (Run)this.getContext().get(Run.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            LogEventHelper.sendFiles((Run)build, (FilePath)workspace, (Map)envVars, (TaskListener)listener, (String)this.step.includes, (String)this.step.excludes, (boolean)this.step.publishFromSlave, (long)LogEventHelper.parseFileSize((String)this.step.sizeLimit));
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, TaskListener.class, FilePath.class, EnvVars.class);
        }

        public String getFunctionName() {
            return "sendSplunkFile";
        }

        @NonNull
        public String getDisplayName() {
            return "Send files to Splunk";
        }
    }
}

