/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.wasPlugin.QualysAuth.AuthType;
import com.qualys.plugins.wasPlugin.QualysAuth.QualysAuth;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSClient;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSResponse;
import com.qualys.plugins.wasPlugin.util.Helper;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.XML;

@Extension
public class ReportAction
implements Action,
RunAction2 {
    private String scanId;
    private String status;
    private String scanReference;
    private String targetUrl;
    private String webAppId;
    private String scanName;
    private boolean isFailConditionsConfigured;
    private JsonObject evaluationResult;
    private String portalUrl;
    private String reportUrl;
    private String apiServer;
    private String apiUser;
    private Secret apiPass;
    private AuthType authType;
    private String clientId;
    private String clientSecret;
    private boolean useProxy;
    private String proxyServer;
    private int proxyPort;
    private String proxyUsername;
    private Secret proxyPassword;
    private JSONObject scanResult;
    private Run<?, ?> run;
    private static final Logger logger = Helper.getLogger(ReportAction.class.getName());

    public ReportAction() {
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public ReportAction(Run<?, ?> run, String scanId, String webAppId, String scanName, String apiServer, AuthType authType, String apiUser, Secret apiPass, String clientId, String clientSecret, boolean useProxy, String proxyServer, int proxyPort, String proxyUsername, Secret proxyPassword, String portalUrl) {
        this.scanId = scanId;
        this.scanName = scanName;
        this.webAppId = webAppId;
        this.apiServer = apiServer;
        this.apiUser = apiUser;
        this.apiPass = apiPass;
        this.authType = authType;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.useProxy = useProxy;
        this.proxyServer = proxyServer;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.portalUrl = portalUrl;
        this.reportUrl = (String)(portalUrl.endsWith("/") ? portalUrl : portalUrl + "/") + "was/#/reports/online-reports/email-report/scan/" + scanId;
        this.run = run;
    }

    public String getScanId() {
        return this.scanId;
    }

    public String getWebAppId() {
        return this.webAppId;
    }

    public String getScanName() {
        return this.scanName;
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public JSONObject getScanResult() {
        this.scanResult = new JSONObject();
        try {
            JsonElement respEl;
            JsonObject respObj;
            String filename = this.run.getArtifactsDir().getAbsolutePath() + File.separator + "qualys_" + this.scanId + ".json";
            File f = new File(filename);
            Gson gson = new Gson();
            if (f.exists()) {
                String resultStr = FileUtils.readFileToString((File)f);
                respObj = (JsonObject)gson.fromJson(resultStr, JsonObject.class);
            } else {
                QualysAuth auth = new QualysAuth();
                auth.setQualysCredentials(this.apiServer, this.authType, this.apiUser, this.apiPass.getPlainText(), this.clientId, this.clientSecret);
                if (this.useProxy) {
                    auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword.getPlainText());
                }
                QualysCSClient qualysClient = new QualysCSClient(auth, System.out);
                QualysCSResponse response = qualysClient.getScanResult(this.scanId);
                respObj = response.response;
            }
            if (respObj.has("evaluationResult") && !respObj.get("evaluationResult").isJsonNull()) {
                this.scanResult.put("isEvaluationResult", (Object)1);
                respEl = respObj.get("evaluationResult");
                JsonObject evalresult = respEl.getAsJsonObject();
                GsonBuilder builder = new GsonBuilder();
                Gson gsonObject = builder.serializeNulls().create();
                String sevVulnsJson = gsonObject.toJson((JsonElement)evalresult);
                JsonElement sevVulnsElement = (JsonElement)gsonObject.fromJson(sevVulnsJson, JsonElement.class);
                this.scanResult.put("evaluationResult", (Object)JSONObject.fromObject((Object)gsonObject.toJson(sevVulnsElement)));
            } else {
                this.scanResult.put("isEvaluationResult", (Object)0);
                this.scanResult.put("evaluationResult", (Object)JSONObject.fromObject((Object)"{}"));
            }
            respEl = respObj.get("ServiceResponse");
            JsonObject serviceResp = respEl.getAsJsonObject();
            JsonElement respCodeObj = serviceResp.get("responseCode");
            if (respCodeObj != null && !respCodeObj.getAsString().equalsIgnoreCase("SUCCESS")) {
                JsonObject respErr = serviceResp.getAsJsonObject("responseErrorDetails");
                logger.info("Server Response: " + respErr.toString());
                String reason = respErr.get("errorMessage").getAsString();
                throw new Exception(reason);
            }
            String[] summaryAttrs = new String[]{"linksCrawled", "nbRequests", "resultsStatus", "authStatus"};
            JsonArray dataArr = serviceResp.get("data").getAsJsonArray();
            JsonObject scanObj = dataArr.get(0).getAsJsonObject().get("WasScan").getAsJsonObject();
            JsonObject kbData = this.batchAndGetKbData(scanObj);
            if (kbData.isJsonNull()) {
                logger.info(String.valueOf(new Timestamp(System.currentTimeMillis())) + " KB data not found. ");
            } else {
                JsonObject vulns = scanObj.getAsJsonObject("vulns");
                JsonArray listArr = vulns.getAsJsonArray("list");
                int vulnsCount = vulns.get("count").getAsInt();
                for (int i = 0; i < vulnsCount; ++i) {
                    String diagnosis;
                    JsonObject listItem = listArr.get(i).getAsJsonObject();
                    JsonObject WasScanVuln = listItem.getAsJsonObject("WasScanVuln");
                    if (!WasScanVuln.has("qid") || WasScanVuln.get("qid").isJsonNull()) continue;
                    String qid = WasScanVuln.get("qid").getAsString();
                    JsonElement solnElement = kbData.get(qid + "_solution");
                    JsonElement diagnosisElement = kbData.get(qid + "_diagnosis");
                    String soln = solnElement != null && !solnElement.isJsonNull() ? solnElement.getAsString() : "";
                    String string = diagnosis = diagnosisElement != null && !diagnosisElement.isJsonNull() ? diagnosisElement.getAsString() : "";
                    if (!soln.isEmpty() && !diagnosis.isEmpty()) {
                        WasScanVuln.addProperty("solution", soln);
                        WasScanVuln.addProperty("diagnosis", diagnosis);
                        continue;
                    }
                    logger.info(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Kb data not found for qid: " + qid);
                }
            }
            JsonObject summary = scanObj.get("summary").getAsJsonObject();
            for (int i = 0; i < summaryAttrs.length; ++i) {
                try {
                    this.scanResult.put(summaryAttrs[i], (Object)summary.get(summaryAttrs[i]).getAsString());
                    continue;
                }
                catch (NullPointerException exc) {
                    logger.info("Couldn't fetch " + summaryAttrs[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(summaryAttrs[i], (Object)" - ");
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Couldn't fetch " + summaryAttrs[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(summaryAttrs[i], (Object)("Exception: " + exc.getMessage()));
                }
            }
            try {
                String scanDuration = scanObj.get("scanDuration").getAsString();
                long secondsL = Long.parseLong(scanDuration, 10);
                String readableTime = Helper.secondsToReadableTime(secondsL);
                this.scanResult.put("scanDuration", (Object)readableTime);
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch scanDuration info. Reason: " + exc.getMessage());
                this.scanResult.put("scanDuration", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch scanDuration info. Reason: " + exc.getMessage());
                this.scanResult.put("scanDuration", (Object)("Exception: " + exc.getMessage()));
            }
            try {
                String scanRef = scanObj.get("reference").getAsString();
                this.scanResult.put("reference", (Object)scanRef);
                this.scanReference = scanRef;
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch reference info. Reason: " + exc.getMessage());
                this.scanResult.put("reference", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch reference info. Reason: " + exc.getMessage());
                this.scanResult.put("reference", (Object)("Exception: " + exc.getMessage()));
            }
            try {
                JsonObject target = scanObj.get("target").getAsJsonObject();
                JsonObject webapp = target.get("webApp").getAsJsonObject();
                String url = webapp.get("url").getAsString();
                this.scanResult.put("targetUrl", (Object)url);
                this.targetUrl = url;
            }
            catch (NullPointerException exc) {
                logger.info("Couldn't fetch targetUrl info. Reason: " + exc.getMessage());
                this.scanResult.put("targetUrl", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch targetUrl info. Reason: " + exc.getMessage());
                this.scanResult.put("targetUrl", (Object)("Exception: " + exc.getMessage()));
            }
            this.scanResult.put("vulnsBySeverity", (Object)JSONObject.fromObject((Object)"{\"1\": 0,\"2\": 0,\"3\": 0,\"4\": 0,\"5\": 0}"));
            try {
                JsonObject stats = scanObj.get("stats").getAsJsonObject();
                JsonObject global = stats.get("global").getAsJsonObject();
                JSONObject obj = new JSONObject();
                for (int i = 1; i <= 5; ++i) {
                    obj.put("" + i, (Object)global.get("nbVulnsLevel" + i).getAsString());
                }
                this.scanResult.put("vulnsBySeverity", (Object)obj);
            }
            catch (NullPointerException exc) {
                exc.printStackTrace();
                logger.info("Couldn't fetch Vulnerabilities by Severity info. Reason: " + exc.getMessage());
                this.scanResult.put("vulnsBySeverity", (Object)"Couldn't find the value in API Response.");
            }
            catch (Exception exc) {
                logger.info("Couldn't fetch Vulnerabilities by Severity info. Reason: " + exc.getMessage());
                this.scanResult.put("vulnsBySeverity", (Object)("Exception: " + exc.getMessage()));
            }
            this.scanResult.put("vulnsTable", (Object)JSONObject.fromObject((Object)"{list:[]}"));
            String[] vulnsSummary = new String[]{"vulns", "sensitiveContents", "igs"};
            for (int i = 0; i < vulnsSummary.length; ++i) {
                try {
                    JsonObject obj = scanObj.get(vulnsSummary[i]).getAsJsonObject();
                    String count = obj.get("count").getAsString();
                    this.scanResult.put(vulnsSummary[i], (Object)count);
                    if (!vulnsSummary[i].equals("vulns") || Integer.parseInt(count) <= 0) continue;
                    this.scanResult.put("vulnsTable", (Object)JSONObject.fromObject((Object)gson.toJson((JsonElement)obj)));
                    continue;
                }
                catch (NullPointerException exc) {
                    logger.info("Couldn't fetch " + vulnsSummary[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(vulnsSummary[i], (Object)"Couldn't find the value in API Response.");
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Couldn't fetch " + vulnsSummary[i] + " info. Reason: " + exc.getMessage());
                    this.scanResult.put(vulnsSummary[i], (Object)("Exception: " + exc.getMessage()));
                }
            }
        }
        catch (Exception e) {
            logger.info("Error parsing scan Result: " + e.getMessage());
            this.scanResult.put("error", (Object)e.getMessage());
            e.printStackTrace();
        }
        return this.scanResult;
    }

    public JSONObject getStatus() {
        JSONObject statusDetails = new JSONObject();
        try {
            if (this.status != null && this.status.equals("FINISHED")) {
                statusDetails.put("value", (Object)"FINISHED");
                statusDetails.put("cssClass", (Object)"success");
                statusDetails.put("targetUrl", (Object)this.targetUrl);
                statusDetails.put("reference", (Object)this.scanReference);
            } else {
                statusDetails = this.parseScanStatus(this.scanId);
                if (statusDetails.get("value") == "FINISHED") {
                    this.status = "FINISHED";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            statusDetails.put("value", (Object)e.getMessage());
            statusDetails.put("cssClass", (Object)"error");
        }
        return statusDetails;
    }

    public JSONObject parseScanStatus(String scanId) throws Exception {
        JSONObject statusObj = new JSONObject();
        JsonObject result = new JsonObject();
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(this.apiServer, this.authType, this.apiUser, this.apiPass.getPlainText(), this.clientId, this.clientSecret);
        if (this.useProxy) {
            auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword.getPlainText());
        }
        QualysCSClient qualysClient = new QualysCSClient(auth, System.out);
        QualysCSResponse resp = qualysClient.getScanDetails(scanId);
        result = resp.response;
        JsonElement respEl = result.get("ServiceResponse");
        JsonObject respObj = respEl.getAsJsonObject();
        JsonElement respCodeObj = respObj.get("responseCode");
        if (respCodeObj != null && !respCodeObj.getAsString().equals("SUCCESS")) {
            JsonObject respErr = respObj.getAsJsonObject("responseErrorDetails");
            logger.info("Server Response: " + respErr.toString());
            String reason = respErr.get("errorMessage").getAsString();
            throw new Exception(reason);
        }
        JsonArray dataArr = respObj.getAsJsonArray("data");
        for (int i = 0; i < dataArr.size(); ++i) {
            JsonElement resultsStatusObj;
            String status;
            JsonObject wasObj;
            block9: {
                JsonObject obj = dataArr.get(i).getAsJsonObject();
                wasObj = obj.getAsJsonObject("WasScan");
                status = wasObj.get("status").getAsString();
                try {
                    String reference = wasObj.get("reference").getAsString();
                    JsonObject targetObj = wasObj.getAsJsonObject("target");
                    JsonObject webObj = targetObj.getAsJsonObject("webApp");
                    String targetUrl = webObj.get("url").getAsString();
                    statusObj.put("reference", (Object)reference);
                    statusObj.put("targetUrl", (Object)targetUrl);
                }
                catch (Exception e) {
                    if (statusObj.get("reference") != null) {
                        statusObj.put("reference", (Object)"");
                    }
                    if (statusObj.get("targetUrl") == null) break block9;
                    statusObj.put("targetUrl", (Object)"");
                }
            }
            if (status.equals("FINISHED") || status.equals("COMPLETED")) {
                statusObj.put("value", (Object)"FINISHED");
                statusObj.put("cssClass", (Object)"success");
                continue;
            }
            statusObj.put("value", (Object)status);
            statusObj.put("cssClass", (Object)"info");
            JsonObject summaryObj = wasObj.getAsJsonObject("summary");
            if (summaryObj == null || summaryObj.isJsonNull() || (resultsStatusObj = summaryObj.get("resultsStatus")) == null || resultsStatusObj.isJsonNull()) continue;
            statusObj.put("resultsStatus", (Object)resultsStatusObj.getAsString());
        }
        return statusObj;
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    public String getDisplayName() {
        return "Qualys WAS Scan Status";
    }

    public String getUrlName() {
        return "qualys_was_scan_status.html";
    }

    public org.json.JSONObject getKbData(String qids) {
        QualysAuth auth = new QualysAuth();
        auth.setQualysCredentials(this.apiServer, this.apiUser, this.apiPass.getPlainText());
        if (this.useProxy) {
            auth.setProxyCredentials(this.proxyServer, this.proxyPort, this.proxyUsername, this.proxyPassword.getPlainText());
        }
        QualysCSClient qualysClient = new QualysCSClient(auth, System.out);
        Object kbData = null;
        String params = "?action=list&details=All&show_supported_modules_info=1&ids=" + qids;
        String responseString = qualysClient.getKbData(params);
        org.json.JSONObject jsonResponse = null;
        if (!responseString.isEmpty()) {
            org.json.JSONObject reponseJson = new org.json.JSONObject(responseString);
            String responseStatusCode = reponseJson.get("statusCode").toString();
            String responseBody = reponseJson.get("body").toString();
            if (responseStatusCode.equals("200")) {
                jsonResponse = XML.toJSONObject((String)responseBody);
            }
        }
        return jsonResponse;
    }

    public JsonObject batchAndGetKbData(JsonObject scanResult) {
        ArrayList<ArrayList<String>> qidBatches = new ArrayList<ArrayList<String>>();
        JsonObject batchResult = new JsonObject();
        try {
            Gson gson = new Gson();
            JsonObject vulns = scanResult.getAsJsonObject("vulns");
            JsonArray listArr = vulns.getAsJsonArray("list");
            int vulnsCount = vulns.get("count").getAsInt();
            ArrayList<String> batch = new ArrayList<String>();
            for (int i = 0; i < vulnsCount; ++i) {
                ArrayList oneBatch;
                JsonObject WasScanVuln;
                JsonObject listItem = listArr.get(i).getAsJsonObject();
                if (!listItem.has("WasScanVuln") || listItem.get("WasScanVuln").isJsonNull() || !(WasScanVuln = listItem.getAsJsonObject("WasScanVuln")).has("qid") || WasScanVuln.get("qid").isJsonNull()) continue;
                String qid = WasScanVuln.get("qid").getAsString();
                batch.add(qid);
                if (batch.size() == 500) {
                    oneBatch = new ArrayList(batch);
                    qidBatches.add(oneBatch);
                    batch.clear();
                    continue;
                }
                if (i != vulnsCount - 1) continue;
                oneBatch = new ArrayList(batch);
                qidBatches.add(oneBatch);
                batch.clear();
            }
            batchResult = this.processBatch(qidBatches);
            return batchResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Error batchAndGetKbData: " + e.getMessage());
            return batchResult;
        }
    }

    public JsonObject processBatch(ArrayList<ArrayList<String>> qids) {
        JsonObject kbData = new JsonObject();
        try {
            int i = 0;
            if (i < qids.size()) {
                String ids = qids.get(i).toString().replace("[", "").replace("]", "").replace(" ", "");
                Gson gson = new Gson();
                org.json.JSONObject kbResult = this.getKbData(ids);
                if (kbResult != null) {
                    org.json.JSONObject kbOutput = kbResult.getJSONObject("KNOWLEDGE_BASE_VULN_LIST_OUTPUT");
                    org.json.JSONObject kbResponse = kbOutput.getJSONObject("RESPONSE");
                    org.json.JSONObject kbVulnList = kbResponse.getJSONObject("VULN_LIST");
                    String scanResultString = gson.toJson((JsonElement)kbData);
                    JSONArray kbVulns = kbVulnList.getJSONArray("VULN");
                    for (int j = 0; j < kbVulns.length(); ++j) {
                        org.json.JSONObject listItem = kbVulns.getJSONObject(j);
                        String qid = Integer.toString(listItem.getInt("QID"));
                        String solution = listItem.getString("SOLUTION");
                        String diagnosis = listItem.getString("DIAGNOSIS");
                        kbData.addProperty(qid + "_solution", solution);
                        kbData.addProperty(qid + "_diagnosis", diagnosis);
                    }
                    return kbData;
                }
                logger.info(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Kb data not found for qids: " + String.valueOf(qids));
                return kbData;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info(String.valueOf(new Timestamp(System.currentTimeMillis())) + " Error processBatch: " + e.getMessage());
            return kbData;
        }
        return kbData;
    }
}

