/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.wasPlugin.QualysClient;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.qualys.plugins.wasPlugin.QualysAuth.QualysAuth;
import com.qualys.plugins.wasPlugin.QualysClient.InvalidAPIResponseException;
import com.qualys.plugins.wasPlugin.QualysClient.QualysBaseClient;
import com.qualys.plugins.wasPlugin.QualysClient.QualysCSResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class QualysCSClient
extends QualysBaseClient {
    public HashMap<String, String> apiMap;
    Logger logger = Logger.getLogger(QualysCSClient.class.getName());

    public QualysCSClient(QualysAuth auth) {
        super(auth, System.out);
        this.populateApiMap();
    }

    public QualysCSClient(QualysAuth auth, PrintStream stream) {
        super(auth, stream);
        this.populateApiMap();
    }

    private void populateApiMap() {
        this.apiMap = new HashMap();
        this.apiMap.put("getOAuthToken", "/auth/oidc");
        this.apiMap.put("getScanResult", "/qps/rest/3.0/download/was/wasscan/");
        this.apiMap.put("getScanDetails", "/qps/rest/3.0/get/was/wasscan/");
        this.apiMap.put("getWebAppCount", "/qps/rest/3.0/count/was/webapp");
        this.apiMap.put("launchScan", "/qps/rest/3.0/launch/was/wasscan");
        this.apiMap.put("getScanStatus", "/qps/rest/3.0/status/was/wasscan/");
        this.apiMap.put("getWebAppDetails", "/qps/rest/3.0/get/was/webapp/");
        this.apiMap.put("listWebApps", "/qps/rest/3.0/search/was/webapp/");
        this.apiMap.put("listOptionProfiles", "/qps/rest/3.0/search/was/optionprofile/");
        this.apiMap.put("listAuthRecords", "/qps/rest/3.0/search/was/webappauthrecord/");
        this.apiMap.put("getKbData", "/api/2.0/fo/knowledge_base/vuln/");
    }

    public QualysCSResponse getScanResult(String scanId) {
        return this.get(this.apiMap.get("getScanResult") + scanId);
    }

    public QualysCSResponse getScanDetails(String scanId) {
        return this.get(this.apiMap.get("getScanDetails") + scanId);
    }

    public QualysCSResponse getWebAppCount() {
        return this.get(this.apiMap.get("getWebAppCount"));
    }

    public QualysCSResponse getScanStatus(String scanId) {
        return this.get(this.apiMap.get("getScanStatus") + scanId);
    }

    public QualysCSResponse launchWASScan(JsonObject requestData) {
        return this.post(this.apiMap.get("launchScan"), requestData, null);
    }

    public QualysCSResponse getWebAppDetails(String webappId) {
        return this.get(this.apiMap.get("getWebAppDetails") + webappId);
    }

    public QualysCSResponse listWebApps(String xml) {
        return this.post(this.apiMap.get("listWebApps"), null, xml);
    }

    public QualysCSResponse listOptionProfiles(String xml) {
        return this.post(this.apiMap.get("listOptionProfiles"), null, xml);
    }

    public QualysCSResponse listAuthRecords(String xml) {
        return this.post(this.apiMap.get("listAuthRecords"), null, xml);
    }

    public String getKbData(String params) {
        return this.getKbApiCall(this.apiMap.get("getKbData") + params);
    }

    public void testConnection() throws Exception {
        try {
            QualysCSResponse response = this.getWebAppCount();
            if (response.errored) {
                if (response.responseCode > 0) {
                    throw new Exception("Please provide valid API and/or Proxy details. Server returned with Response code: " + response.responseCode);
                }
                throw new Exception("Please provide valid API and/or Proxy details. Error Message: " + response.errorMessage);
            }
            JsonObject respObj = response.response;
            if (response.responseCode < 200 || response.responseCode > 299) {
                String err_message = respObj.has("errorMessage") ? "Error message: " + respObj.get("errorMessage").getAsString() : "";
                throw new Exception("HTTP Response code from server: " + response.responseCode + ". " + err_message);
            }
            JsonObject serviceResponseObj = respObj.get("ServiceResponse").getAsJsonObject();
            String responseCodeString = serviceResponseObj.get("responseCode").getAsString();
            if (!responseCodeString.equalsIgnoreCase("success")) {
                JsonObject detailsObj = serviceResponseObj.get("responseErrorDetails").getAsJsonObject();
                String errorMessage = detailsObj.get("errorMessage").getAsString();
                String errorResolution = detailsObj.get("errorResolution").getAsString();
                throw new Exception("[" + responseCodeString + "] " + errorMessage + ", " + errorResolution);
            }
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
            throw new Exception("Please provide valid API and/or Proxy details.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private QualysCSResponse get(String apiPath) {
        QualysCSResponse apiResponse = new QualysCSResponse();
        Object apiResponseString = "";
        CloseableHttpClient httpclient = null;
        try {
            URL url = this.getAbsoluteUrl(apiPath);
            this.stream.println("Making Request: " + url.toString());
            httpclient = this.getHttpClient();
            HttpGet getRequest = new HttpGet(url.toString());
            this.getCommonHeaders().forEach((arg_0, arg_1) -> ((HttpGet)getRequest).addHeader(arg_0, arg_1));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)getRequest);
            apiResponse.responseCode = response.getStatusLine().getStatusCode();
            this.logger.info("Server returned with ResponseCode: " + apiResponse.responseCode);
            if (response.getEntity() != null) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                while ((output = br.readLine()) != null) {
                    apiResponseString = (String)apiResponseString + output;
                }
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonTree = jsonParser.parse((String)apiResponseString);
                if (!jsonTree.isJsonObject()) {
                    throw new InvalidAPIResponseException();
                }
                apiResponse.response = jsonTree.getAsJsonObject();
            }
        }
        catch (JsonParseException je) {
            apiResponse.errored = true;
            apiResponse.errorMessage = apiResponseString;
        }
        catch (Exception e) {
            apiResponse.errored = true;
            apiResponse.errorMessage = e.getMessage();
        }
        return apiResponse;
    }

    private String getKbApiCall(String apiPath) {
        String responseContent = "";
        CloseableHttpClient httpclient = null;
        try {
            URL url = this.getAbsoluteUrl(apiPath);
            this.stream.println("Making Request: " + url.toString());
            httpclient = this.getHttpClient();
            HttpGet getRequest = new HttpGet(url.toString());
            this.getCommonHeaders().forEach((arg_0, arg_1) -> ((HttpGet)getRequest).addHeader(arg_0, arg_1));
            getRequest.addHeader("X-Requested-With", "Jenkins");
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)getRequest);
            if (response.getEntity() != null) {
                JSONObject responseJson = new JSONObject();
                responseJson.put("statusCode", response.getStatusLine().getStatusCode());
                String responseBody = "{}";
                if (response.getEntity() != null) {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                responseJson.put("body", (Object)responseBody);
                responseContent = responseJson.toString();
                return responseContent;
            }
        }
        catch (Exception e) {
            this.logger.info("Error occured in getKBApi call: " + e.getMessage());
        }
        return "";
    }

    private QualysCSResponse post(String apiPath, JsonObject requestDataJson, String requestXmlString) {
        QualysCSResponse apiResponse = new QualysCSResponse();
        Object apiResponseString = "";
        CloseableHttpClient httpclient = null;
        try {
            StringEntity entity;
            URL url = this.getAbsoluteUrl(apiPath);
            this.stream.println("Making Request: " + url.toString());
            httpclient = this.getHttpClient();
            HttpPost postRequest = new HttpPost(url.toString());
            this.getCommonHeaders().forEach((arg_0, arg_1) -> ((HttpPost)postRequest).addHeader(arg_0, arg_1));
            Gson gson = new Gson();
            if (requestDataJson != null) {
                postRequest.removeHeaders("Content-Type");
                postRequest.addHeader("Content-Type", "application/json");
                entity = new StringEntity(gson.toJson((JsonElement)requestDataJson));
                postRequest.setEntity((HttpEntity)entity);
            } else if (requestXmlString != null) {
                postRequest.removeHeaders("Content-Type");
                postRequest.addHeader("Content-Type", "application/xml");
                entity = new ByteArrayEntity(requestXmlString.getBytes("UTF-8"));
                postRequest.setEntity((HttpEntity)entity);
            }
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)postRequest);
            apiResponse.responseCode = response.getStatusLine().getStatusCode();
            this.logger.info("Server returned with ResponseCode: " + apiResponse.responseCode);
            if (response.getEntity() != null) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                while ((output = br.readLine()) != null) {
                    apiResponseString = (String)apiResponseString + output;
                }
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonTree = jsonParser.parse((String)apiResponseString);
                if (!jsonTree.isJsonObject()) {
                    throw new InvalidAPIResponseException();
                }
                apiResponse.response = jsonTree.getAsJsonObject();
            }
        }
        catch (JsonParseException je) {
            apiResponse.errored = true;
            apiResponse.errorMessage = apiResponseString;
        }
        catch (Exception e) {
            apiResponse.errored = true;
            apiResponse.errorMessage = e.getMessage();
        }
        return apiResponse;
    }
}

