/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.containerSecurity.common.QualysCriteria;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;

public class CvssCriteria {
    String version;
    double configuredScore;
    int found;
    HashMap<String, Integer> foundMap;
    boolean checkPotentialVulns = false;

    public CvssCriteria(JsonObject cvssFilter) {
        this.processFilter(cvssFilter);
    }

    public CvssCriteria(JsonObject cvssFilter, boolean checkPotentialVulns) {
        this.checkPotentialVulns = checkPotentialVulns;
        this.processFilter(cvssFilter);
    }

    private void processFilter(JsonObject cvssFilter) {
        this.version = "";
        this.configuredScore = 0.0;
        this.found = 0;
        this.foundMap = new HashMap();
        this.version = cvssFilter.get("version").getAsString();
        if (this.version.equals("2")) {
            this.version = "";
        }
        this.configuredScore = cvssFilter.get("configured").getAsDouble();
    }

    public JsonObject evaluate(JsonArray vulns) {
        JsonObject cvssResult = new JsonObject();
        cvssResult.addProperty("configured", (Number)this.configuredScore);
        String cvssVersion = String.format("cvss%sInfo", this.version);
        this.found = 0;
        this.foundMap = new HashMap();
        for (JsonElement vuln : vulns) {
            Integer currentCount;
            JsonObject cvssObject;
            String baseScoreString;
            double baseScore;
            JsonObject vulnObject = vuln.getAsJsonObject();
            String typeDetected = "";
            if (vulnObject.has("typeDetected")) {
                typeDetected = vulnObject.get("typeDetected").getAsString();
            }
            if (typeDetected.equals("POTENTIAL") && !this.checkPotentialVulns) continue;
            if (cvssVersion.equals("cvssmaxOfv2andv3Info")) {
                Integer currentCount2;
                if ((!vulnObject.has("cvssInfo") || vulnObject.get("cvssInfo").isJsonNull()) && (!vulnObject.has("cvss3Info") || vulnObject.get("cvss3Info").isJsonNull())) continue;
                JsonObject cvss2Object = vulnObject.get("cvssInfo").getAsJsonObject();
                String cvss2baseScoreString = cvss2Object.get("baseScore").getAsString();
                double cvss2baseScore = Double.parseDouble(cvss2baseScoreString);
                JsonObject cvss3Object = vulnObject.get("cvss3Info").getAsJsonObject();
                String cvss3baseScoreString = cvss3Object.get("baseScore").getAsString();
                double cvss3baseScore = Double.parseDouble(cvss3baseScoreString);
                double baseScore2 = Math.max(cvss2baseScore, cvss3baseScore);
                String baseScoreString2 = String.valueOf(baseScore2);
                if (!(baseScore2 >= this.configuredScore)) continue;
                ++this.found;
                if (!this.foundMap.containsKey(baseScoreString2)) {
                    this.foundMap.put(baseScoreString2, 0);
                }
                Integer n = currentCount2 = this.foundMap.get(baseScoreString2);
                Integer n2 = currentCount2 = Integer.valueOf(currentCount2 + 1);
                this.foundMap.put(baseScoreString2, currentCount2);
                continue;
            }
            if (!vulnObject.has(cvssVersion) || vulnObject.get(cvssVersion).isJsonNull() || !((baseScore = Double.parseDouble(baseScoreString = (cvssObject = vulnObject.get(cvssVersion).getAsJsonObject()).get("baseScore").getAsString())) >= this.configuredScore)) continue;
            ++this.found;
            if (!this.foundMap.containsKey(baseScoreString)) {
                this.foundMap.put(baseScoreString, 0);
            }
            Integer n = currentCount = this.foundMap.get(baseScoreString);
            Integer n3 = currentCount = Integer.valueOf(currentCount + 1);
            this.foundMap.put(baseScoreString, currentCount);
        }
        cvssResult.addProperty("found", (Number)this.found);
        cvssResult.addProperty("version", this.version);
        if (this.found > 0) {
            cvssResult.addProperty("result", Boolean.valueOf(false));
            Gson gson = new GsonBuilder().create();
            String foundMapJson = gson.toJson(this.foundMap);
            JsonParser parser = new JsonParser();
            JsonObject foundMapObject = parser.parse(foundMapJson).getAsJsonObject();
            cvssResult.add("foundMap", (JsonElement)foundMapObject);
        } else {
            cvssResult.addProperty("result", Boolean.valueOf(true));
        }
        return cvssResult;
    }
}

