/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.Metric;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class MetricAssert
extends AbstractComparableAssert<MetricAssert, Metric> {
    public MetricAssert(Metric actual) {
        super((Comparable)actual, MetricAssert.class);
    }

    @CheckReturnValue
    public static MetricAssert assertThat(Metric actual) {
        return new MetricAssert(actual);
    }

    public MetricAssert isContainer() {
        this.isNotNull();
        if (!((Metric)this.actual).isContainer()) {
            this.failWithMessage("\nExpecting that actual Metric is container but is not.", new Object[0]);
        }
        return this;
    }

    public MetricAssert isNotContainer() {
        this.isNotNull();
        if (((Metric)this.actual).isContainer()) {
            this.failWithMessage("\nExpecting that actual Metric is not container but is.", new Object[0]);
        }
        return this;
    }

    public MetricAssert hasCoverageMetrics(Metric ... coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
        }
        Metric cfr_ignored_0 = (Metric)this.actual;
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)Metric.getCoverageMetrics(), (Object[])coverageMetrics);
        return this;
    }

    public MetricAssert hasCoverageMetrics(Collection<? extends Metric> coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Metric cfr_ignored_0 = (Metric)this.actual;
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)Metric.getCoverageMetrics(), coverageMetrics.toArray());
        return this;
    }

    public MetricAssert hasOnlyCoverageMetrics(Metric ... coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
        }
        Metric cfr_ignored_0 = (Metric)this.actual;
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)Metric.getCoverageMetrics(), (Object[])coverageMetrics);
        return this;
    }

    public MetricAssert hasOnlyCoverageMetrics(Collection<? extends Metric> coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Metric cfr_ignored_0 = (Metric)this.actual;
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)Metric.getCoverageMetrics(), coverageMetrics.toArray());
        return this;
    }

    public MetricAssert doesNotHaveCoverageMetrics(Metric ... coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
        }
        Metric cfr_ignored_0 = (Metric)this.actual;
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)Metric.getCoverageMetrics(), (Object[])coverageMetrics);
        return this;
    }

    public MetricAssert doesNotHaveCoverageMetrics(Collection<? extends Metric> coverageMetrics) {
        this.isNotNull();
        if (coverageMetrics == null) {
            this.failWithMessage("Expecting coverageMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Metric cfr_ignored_0 = (Metric)this.actual;
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)Metric.getCoverageMetrics(), coverageMetrics.toArray());
        return this;
    }

    public MetricAssert hasNoCoverageMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have coverageMetrics but had :\n  <%s>";
        Metric cfr_ignored_0 = (Metric)this.actual;
        if (Metric.getCoverageMetrics().iterator().hasNext()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.actual;
            Metric cfr_ignored_1 = (Metric)this.actual;
            objectArray[1] = Metric.getCoverageMetrics();
            this.failWithMessage(assertjErrorMessage, objectArray);
        }
        return this;
    }

    public MetricAssert hasTendency(Metric.MetricTendency tendency) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting tendency of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric.MetricTendency actualTendency = ((Metric)this.actual).getTendency();
        if (!Objects.deepEquals(actualTendency, tendency)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, tendency, actualTendency});
        }
        return this;
    }
}

