/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.Coverage;
import com.parasoft.findings.jenkins.coverage.model.Metric;
import com.parasoft.findings.jenkins.coverage.model.Percentage;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class CoverageAssert
extends AbstractObjectAssert<CoverageAssert, Coverage> {
    public CoverageAssert(Coverage actual) {
        super((Object)actual, CoverageAssert.class);
    }

    @CheckReturnValue
    public static CoverageAssert assertThat(Coverage actual) {
        return new CoverageAssert(actual);
    }

    public CoverageAssert hasCovered(int covered) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting covered of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualCovered = ((Coverage)this.actual).getCovered();
        if (actualCovered != covered) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, covered, actualCovered});
        }
        return this;
    }

    public CoverageAssert hasCoveredPercentage(Percentage coveredPercentage) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting coveredPercentage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Percentage actualCoveredPercentage = ((Coverage)this.actual).getCoveredPercentage();
        if (!Objects.deepEquals(actualCoveredPercentage, coveredPercentage)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, coveredPercentage, actualCoveredPercentage});
        }
        return this;
    }

    public CoverageAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((Coverage)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public CoverageAssert hasMissed(int missed) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting missed of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualMissed = ((Coverage)this.actual).getMissed();
        if (actualMissed != missed) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, missed, actualMissed});
        }
        return this;
    }

    public CoverageAssert isSet() {
        this.isNotNull();
        if (!((Coverage)this.actual).isSet()) {
            this.failWithMessage("\nExpecting that actual Coverage is set but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageAssert isNotSet() {
        this.isNotNull();
        if (((Coverage)this.actual).isSet()) {
            this.failWithMessage("\nExpecting that actual Coverage is not set but is.", new Object[0]);
        }
        return this;
    }

    public CoverageAssert hasTotal(int total) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting total of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualTotal = ((Coverage)this.actual).getTotal();
        if (actualTotal != total) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, total, actualTotal});
        }
        return this;
    }
}

