/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.model;

import com.parasoft.findings.jenkins.coverage.model.ContainerNode;
import com.parasoft.findings.jenkins.coverage.model.FileNode;
import com.parasoft.findings.jenkins.coverage.model.MethodNode;
import com.parasoft.findings.jenkins.coverage.model.Metric;
import com.parasoft.findings.jenkins.coverage.model.Node;
import com.parasoft.findings.jenkins.coverage.model.Value;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class ContainerNodeAssert
extends AbstractObjectAssert<ContainerNodeAssert, ContainerNode> {
    public ContainerNodeAssert(ContainerNode actual) {
        super((Object)actual, ContainerNodeAssert.class);
    }

    @CheckReturnValue
    public static ContainerNodeAssert assertThat(ContainerNode actual) {
        return new ContainerNodeAssert(actual);
    }

    public ContainerNodeAssert hasAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public ContainerNodeAssert hasAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public ContainerNodeAssert hasOnlyAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveAllFileNodes(FileNode ... allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllFileNodes(), (Object[])allFileNodes);
        return this;
    }

    public ContainerNodeAssert doesNotHaveAllFileNodes(Collection<? extends FileNode> allFileNodes) {
        this.isNotNull();
        if (allFileNodes == null) {
            this.failWithMessage("Expecting allFileNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllFileNodes(), allFileNodes.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoAllFileNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allFileNodes but had :\n  <%s>";
        if (((ContainerNode)this.actual).getAllFileNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getAllFileNodes()});
        }
        return this;
    }

    public ContainerNodeAssert hasAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public ContainerNodeAssert hasAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public ContainerNodeAssert hasOnlyAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveAllMethodNodes(MethodNode ... allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllMethodNodes(), (Object[])allMethodNodes);
        return this;
    }

    public ContainerNodeAssert doesNotHaveAllMethodNodes(Collection<? extends MethodNode> allMethodNodes) {
        this.isNotNull();
        if (allMethodNodes == null) {
            this.failWithMessage("Expecting allMethodNodes parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getAllMethodNodes(), allMethodNodes.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoAllMethodNodes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have allMethodNodes but had :\n  <%s>";
        if (((ContainerNode)this.actual).getAllMethodNodes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getAllMethodNodes()});
        }
        return this;
    }

    public ContainerNodeAssert hasChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public ContainerNodeAssert hasChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public ContainerNodeAssert hasOnlyChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveChildren(Node ... children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getChildren(), (Object[])children);
        return this;
    }

    public ContainerNodeAssert doesNotHaveChildren(Collection<? extends Node> children) {
        this.isNotNull();
        if (children == null) {
            this.failWithMessage("Expecting children parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getChildren(), children.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoChildren() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have children but had :\n  <%s>";
        if (((ContainerNode)this.actual).getChildren().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getChildren()});
        }
        return this;
    }

    public ContainerNodeAssert hasChildren() {
        this.isNotNull();
        if (!((ContainerNode)this.actual).hasChildren()) {
            this.failWithMessage("\nExpecting that actual ContainerNode has children but does not have.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert doesNotHaveChildren() {
        this.isNotNull();
        if (((ContainerNode)this.actual).hasChildren()) {
            this.failWithMessage("\nExpecting that actual ContainerNode does not have children but has.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert isEmpty() {
        this.isNotNull();
        if (!((ContainerNode)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual ContainerNode is empty but is not.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert isNotEmpty() {
        this.isNotNull();
        if (((ContainerNode)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual ContainerNode is not empty but is.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert hasFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public ContainerNodeAssert hasFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getFiles(), files.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public ContainerNodeAssert hasOnlyFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getFiles(), files.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public ContainerNodeAssert doesNotHaveFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getFiles(), files.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoFiles() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have files but had :\n  <%s>";
        if (((ContainerNode)this.actual).getFiles().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getFiles()});
        }
        return this;
    }

    public ContainerNodeAssert hasMetric(Metric metric) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metric of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Metric actualMetric = ((ContainerNode)this.actual).getMetric();
        if (!Objects.deepEquals(actualMetric, metric)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metric, actualMetric});
        }
        return this;
    }

    public ContainerNodeAssert hasMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public ContainerNodeAssert hasMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public ContainerNodeAssert hasOnlyMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveMetrics(Metric ... metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getMetrics(), (Object[])metrics);
        return this;
    }

    public ContainerNodeAssert doesNotHaveMetrics(Collection<? extends Metric> metrics) {
        this.isNotNull();
        if (metrics == null) {
            this.failWithMessage("Expecting metrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getMetrics(), metrics.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have metrics but had :\n  <%s>";
        if (((ContainerNode)this.actual).getMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getMetrics()});
        }
        return this;
    }

    public ContainerNodeAssert hasModifiedLines() {
        this.isNotNull();
        if (!((ContainerNode)this.actual).hasModifiedLines()) {
            this.failWithMessage("\nExpecting that actual ContainerNode has modified lines but does not have.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert doesNotHaveModifiedLines() {
        this.isNotNull();
        if (((ContainerNode)this.actual).hasModifiedLines()) {
            this.failWithMessage("\nExpecting that actual ContainerNode does not have modified lines but has.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((ContainerNode)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public ContainerNodeAssert hasParasoftToolName(String parasoftToolName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parasoftToolName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParasoftToolName = ((ContainerNode)this.actual).getParasoftToolName();
        if (!Objects.deepEquals(actualParasoftToolName, parasoftToolName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parasoftToolName, actualParasoftToolName});
        }
        return this;
    }

    public ContainerNodeAssert hasParent(Node parent) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Node actualParent = ((ContainerNode)this.actual).getParent();
        if (!Objects.deepEquals(actualParent, parent)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parent, actualParent});
        }
        return this;
    }

    public ContainerNodeAssert hasParent() {
        this.isNotNull();
        if (!((ContainerNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual ContainerNode has parent but does not have.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert doesNotHaveParent() {
        this.isNotNull();
        if (((ContainerNode)this.actual).hasParent()) {
            this.failWithMessage("\nExpecting that actual ContainerNode does not have parent but has.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert hasParentName(String parentName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting parentName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualParentName = ((ContainerNode)this.actual).getParentName();
        if (!Objects.deepEquals(actualParentName, parentName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, parentName, actualParentName});
        }
        return this;
    }

    public ContainerNodeAssert isRoot() {
        this.isNotNull();
        if (!((ContainerNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual ContainerNode is root but is not.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert isNotRoot() {
        this.isNotNull();
        if (((ContainerNode)this.actual).isRoot()) {
            this.failWithMessage("\nExpecting that actual ContainerNode is not root but is.", new Object[0]);
        }
        return this;
    }

    public ContainerNodeAssert hasSourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public ContainerNodeAssert hasSourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlySourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public ContainerNodeAssert hasOnlySourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveSourceFolders(String ... sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getSourceFolders(), (Object[])sourceFolders);
        return this;
    }

    public ContainerNodeAssert doesNotHaveSourceFolders(Collection<? extends String> sourceFolders) {
        this.isNotNull();
        if (sourceFolders == null) {
            this.failWithMessage("Expecting sourceFolders parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getSourceFolders(), sourceFolders.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoSourceFolders() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have sourceFolders but had :\n  <%s>";
        if (((ContainerNode)this.actual).getSourceFolders().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getSourceFolders()});
        }
        return this;
    }

    public ContainerNodeAssert hasValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public ContainerNodeAssert hasValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public ContainerNodeAssert hasOnlyValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveValueMetrics(Metric ... valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValueMetrics(), (Object[])valueMetrics);
        return this;
    }

    public ContainerNodeAssert doesNotHaveValueMetrics(Collection<? extends Metric> valueMetrics) {
        this.isNotNull();
        if (valueMetrics == null) {
            this.failWithMessage("Expecting valueMetrics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValueMetrics(), valueMetrics.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoValueMetrics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have valueMetrics but had :\n  <%s>";
        if (((ContainerNode)this.actual).getValueMetrics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getValueMetrics()});
        }
        return this;
    }

    public ContainerNodeAssert hasValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValues(), (Object[])values);
        return this;
    }

    public ContainerNodeAssert hasValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValues(), values.toArray());
        return this;
    }

    public ContainerNodeAssert hasOnlyValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValues(), (Object[])values);
        return this;
    }

    public ContainerNodeAssert hasOnlyValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValues(), values.toArray());
        return this;
    }

    public ContainerNodeAssert doesNotHaveValues(Value ... values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValues(), (Object[])values);
        return this;
    }

    public ContainerNodeAssert doesNotHaveValues(Collection<? extends Value> values) {
        this.isNotNull();
        if (values == null) {
            this.failWithMessage("Expecting values parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ContainerNode)this.actual).getValues(), values.toArray());
        return this;
    }

    public ContainerNodeAssert hasNoValues() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have values but had :\n  <%s>";
        if (((ContainerNode)this.actual).getValues().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ContainerNode)this.actual).getValues()});
        }
        return this;
    }
}

