/*
 * Decompiled with CFR 0.152.
 */
package com.parasoft.findings.jenkins.coverage.api.metrics.color;

import com.parasoft.findings.jenkins.coverage.api.metrics.color.ColorProvider;
import java.awt.Color;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class ColorProviderDisplayColorsAssert
extends AbstractObjectAssert<ColorProviderDisplayColorsAssert, ColorProvider.DisplayColors> {
    public ColorProviderDisplayColorsAssert(ColorProvider.DisplayColors actual) {
        super((Object)actual, ColorProviderDisplayColorsAssert.class);
    }

    @CheckReturnValue
    public static ColorProviderDisplayColorsAssert assertThat(ColorProvider.DisplayColors actual) {
        return new ColorProviderDisplayColorsAssert(actual);
    }

    public ColorProviderDisplayColorsAssert hasFillColor(Color fillColor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fillColor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Color actualFillColor = ((ColorProvider.DisplayColors)this.actual).getFillColor();
        if (!Objects.deepEquals(actualFillColor, fillColor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fillColor, actualFillColor});
        }
        return this;
    }

    public ColorProviderDisplayColorsAssert hasFillColorAsRGBHex(String fillColorAsRGBHex) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fillColorAsRGBHex of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFillColorAsRGBHex = ((ColorProvider.DisplayColors)this.actual).getFillColorAsRGBHex();
        if (!Objects.deepEquals(actualFillColorAsRGBHex, fillColorAsRGBHex)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fillColorAsRGBHex, actualFillColorAsRGBHex});
        }
        return this;
    }

    public ColorProviderDisplayColorsAssert hasLineColor(Color lineColor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineColor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Color actualLineColor = ((ColorProvider.DisplayColors)this.actual).getLineColor();
        if (!Objects.deepEquals(actualLineColor, lineColor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineColor, actualLineColor});
        }
        return this;
    }

    public ColorProviderDisplayColorsAssert hasLineColorAsRGBHex(String lineColorAsRGBHex) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineColorAsRGBHex of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLineColorAsRGBHex = ((ColorProvider.DisplayColors)this.actual).getLineColorAsRGBHex();
        if (!Objects.deepEquals(actualLineColorAsRGBHex, lineColorAsRGBHex)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineColorAsRGBHex, actualLineColorAsRGBHex});
        }
        return this;
    }
}

