/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.datapipe.jenkins.vault.credentials.VaultAppRoleCredential;
import hudson.util.Secret;
import java.util.Optional;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"hashicorp-vault-plugin"})
public class VaultAppRoleCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "vaultAppRole".equals(type);
    }

    public VaultAppRoleCredential convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "vaultAppRole definition contains no data");
        String roleIdBase64 = SecretUtils.getNonNullSecretData(secret, "roleId", "vaultAppRole credential is missing the roleId");
        String secretIdBase64 = SecretUtils.getNonNullSecretData(secret, "secretId", "vaultAppRole credential is missing the secretId");
        Optional<String> pathBase64 = SecretUtils.getOptionalSecretData(secret, "path", "vaultAppRole credential is missing the path");
        Optional<String> namespaceBase64 = SecretUtils.getOptionalSecretData(secret, "namespace", "vaultAppRole credential is missing the namespace");
        String roleId = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(roleIdBase64), "vaultAppRole credential has an invalid roleId (must be base64 encoded UTF-8)");
        String secretId = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(secretIdBase64), "vaultAppRole credential has an invalid secretId (must be base64 encoded UTF-8)");
        String path = "approle";
        if (pathBase64.isPresent()) {
            path = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(pathBase64.get()), "vaultAppRole credential has an invalid path (must be base64 encoded UTF-8)");
        }
        VaultAppRoleCredential cred = new VaultAppRoleCredential(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), roleId, Secret.fromString((String)secretId), path);
        if (namespaceBase64.isPresent()) {
            String namespace = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(namespaceBase64.get()), "vaultAppRole credential has an invalid namespace (must be base64 encoded UTF-8)");
            cred.setNamespace(namespace);
        }
        return cred;
    }
}

