/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import io.fabric8.kubernetes.api.model.Secret;
import java.util.Optional;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"aws-credentials"})
public class AWSCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "aws".equals(type);
    }

    public AWSCredentialsImpl convert(Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "aws definition contains no data");
        Optional<String> accessKeyBase64 = SecretUtils.getOptionalSecretData(secret, "accessKey", "aws credential is missing the accessKey");
        String accessKey = null;
        if (accessKeyBase64.isPresent()) {
            accessKey = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(accessKeyBase64.get()), "aws credential has an invalid accessKey (must be base64 encoded UTF-8)");
        }
        Optional<String> secretKeyBase64 = SecretUtils.getOptionalSecretData(secret, "secretKey", "aws credential is missing the secretKey");
        String secretKey = null;
        if (secretKeyBase64.isPresent()) {
            secretKey = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(secretKeyBase64.get()), "aws credential has an invalid secretKey (must be base64 encoded UTF-8)");
        }
        Optional<String> iamRoleArnBase64 = SecretUtils.getOptionalSecretData(secret, "iamRoleArn", "aws credential: failed to retrieve optional parameter iamRoleArn");
        String iamRoleArn = null;
        if (iamRoleArnBase64.isPresent()) {
            iamRoleArn = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(iamRoleArnBase64.get()), "aws credential has an invalid iamRoleArn (must be base64 encoded UTF-8)");
        }
        Optional<String> iamMfaSerialNumberBase64 = SecretUtils.getOptionalSecretData(secret, "iamMfaSerialNumber", "aws credential: failed to retrieve optional parameter iamMfaSerialNumber");
        String iamMfaSerialNumber = null;
        if (iamMfaSerialNumberBase64.isPresent()) {
            iamMfaSerialNumber = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(iamMfaSerialNumberBase64.get()), "aws credential has an invalid iamMfaSerialNumber (must be base64 encoded UTF-8)");
        }
        return new AWSCredentialsImpl(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), accessKey, secretKey, SecretUtils.getCredentialDescription(secret), iamRoleArn, iamMfaSerialNumber);
    }
}

