/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.KubernetesCredentialProvider;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.export.ExportedBean;

public class KubernetesCredentialsStore
extends CredentialsStore {
    private final KubernetesCredentialProvider provider;
    private final KubernetesCredentialsStoreAction action = new KubernetesCredentialsStoreAction(this);
    private final ItemGroup<?> context;

    public KubernetesCredentialsStore(KubernetesCredentialProvider provider, ItemGroup<?> context) {
        super(KubernetesCredentialProvider.class);
        this.provider = provider;
        this.context = context;
    }

    @NonNull
    public ModelObject getContext() {
        return this.context;
    }

    public boolean hasPermission(@NonNull Authentication authentication, @NonNull Permission permission) {
        if (!CredentialsProvider.VIEW.equals((Object)permission)) {
            return false;
        }
        AccessControlled ac = this.getAccessControlledContext();
        if (ac != null) {
            return ac.hasPermission(permission);
        }
        return Jenkins.getInstance().getACL().hasPermission(authentication, permission);
    }

    @NonNull
    public List<Credentials> getCredentials(@NonNull Domain domain) {
        if (!Domain.global().equals((Object)domain)) {
            return Collections.emptyList();
        }
        AccessControlled ac = this.getAccessControlledContext();
        if (ac == null ? Jenkins.getInstance().getACL().hasPermission(CredentialsProvider.VIEW) : ac.hasPermission(CredentialsProvider.VIEW)) {
            return this.provider.getCredentials(Credentials.class, this.context, ACL.SYSTEM);
        }
        return Collections.emptyList();
    }

    @Nullable
    private AccessControlled getAccessControlledContext() {
        AccessControlled ac = null;
        ItemGroup ig = this.context;
        while (ac == null) {
            if (ig instanceof AccessControlled) {
                ac = (AccessControlled)ig;
                continue;
            }
            if (!(ig instanceof Item)) break;
            ig = ((Item)ig).getParent();
        }
        return ac;
    }

    public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) {
        throw new UnsupportedOperationException();
    }

    public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public CredentialsStoreAction getStoreAction() {
        return this.action;
    }

    @ExportedBean
    public static class KubernetesCredentialsStoreAction
    extends CredentialsStoreAction {
        private final KubernetesCredentialsStore store;

        private KubernetesCredentialsStoreAction(KubernetesCredentialsStore store) {
            this.store = store;
        }

        @NonNull
        public CredentialsStore getStore() {
            return this.store;
        }

        public String getIconClassName() {
            return this.isVisible() ? "symbol-kubernetes plugin-kubernetes-credentials-provider" : null;
        }

        public String getDisplayName() {
            return "Kubernetes";
        }
    }
}

