/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.KubernetesCredentialsStore;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.KubernetesSourcedCredential;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.LabelSelectorExpressions;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.LabelSelectorParseException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.TermMilestone;
import hudson.init.Terminator;
import hudson.model.AdministrativeMonitor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.triggers.SafeTimerTask;
import hudson.util.AdministrativeError;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.util.SetContextClassLoader;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class KubernetesCredentialProvider
extends CredentialsProvider
implements Watcher<Secret> {
    private static final Logger LOG = Logger.getLogger(KubernetesCredentialProvider.class.getName());
    private ConcurrentHashMap<String, KubernetesSourcedCredential> credentials = new ConcurrentHashMap();
    @CheckForNull
    private KubernetesClient client;
    @CheckForNull
    private Watch watch;
    private boolean reconnectClientOnException = Boolean.parseBoolean(System.getProperty(KubernetesCredentialProvider.class.getName() + ".reconnectClientOnException", "true"));
    private int reconnectClientDelayMins = Integer.getInteger(KubernetesCredentialProvider.class.getName() + ".reconnectClientDelayMins", 5);
    private final Map<ModelObject, KubernetesCredentialsStore> lazyStoreCache = new HashMap<ModelObject, KubernetesCredentialsStore>();
    static final String LABEL_SELECTOR = KubernetesCredentialProvider.class.getName() + ".labelSelector";

    KubernetesClient getKubernetesClient() {
        if (this.client == null) {
            ConfigBuilder cb = new ConfigBuilder();
            Config config = cb.build();
            try (SetContextClassLoader ignored = new SetContextClassLoader(KubernetesCredentialProvider.class);){
                this.client = new KubernetesClientBuilder().withConfig(config).build();
            }
        }
        return this.client;
    }

    @Initializer(after=InitMilestone.PLUGINS_PREPARED, fatal=false)
    @Restricted(value={NoExternalUse.class})
    public void startWatchingForSecrets() {
        String initAdminMonitorId = ((Object)((Object)this)).getClass().getName() + ".initialize";
        String labelSelectorAdminMonitorId = ((Object)((Object)this)).getClass().getName() + ".labelSelector";
        String labelSelector = System.getProperty(LABEL_SELECTOR);
        try {
            KubernetesClient _client = this.getKubernetesClient();
            LOG.log(Level.FINER, "Using namespace: {0}", String.valueOf(_client.getNamespace()));
            LabelSelector selector = LabelSelectorExpressions.parse(labelSelector);
            LOG.log(Level.INFO, "retrieving secrets with selector: {0}, {1}", new String[]{"jenkins.io/credentials-type", Objects.toString(selector)});
            LOG.log(Level.FINER, "retrieving secrets");
            SecretList list = (SecretList)((FilterWatchListDeletable)((FilterWatchListDeletable)_client.secrets().withLabelSelector(selector)).withLabel("jenkins.io/credentials-type")).list();
            ConcurrentHashMap<String, KubernetesSourcedCredential> _credentials = new ConcurrentHashMap<String, KubernetesSourcedCredential>();
            List secretList = list.getItems();
            for (Secret s : secretList) {
                LOG.log(Level.FINE, "Secret Added - {0}", SecretUtils.getCredentialId(s));
                this.addSecret(s, _credentials);
            }
            this.credentials = _credentials;
            LOG.log(Level.FINER, "registering watch");
            ListOptionsBuilder lob = new ListOptionsBuilder();
            lob.withResourceVersion(list.getMetadata().getResourceVersion());
            this.watch = ((FilterWatchListDeletable)((FilterWatchListDeletable)_client.secrets().withLabelSelector(selector)).withLabel("jenkins.io/credentials-type")).watch(lob.build(), (Watcher)this);
            LOG.log(Level.FINER, "registered watch, retrieving secrets");
            this.clearAdminMonitors(initAdminMonitorId, labelSelectorAdminMonitorId);
        }
        catch (KubernetesClientException kex) {
            LOG.log(Level.SEVERE, "Failed to initialise k8s secret provider, secrets from Kubernetes will not be available", kex);
            if (this.reconnectClientOnException) {
                this.reconnectLater();
            }
            this.clearAdminMonitors(initAdminMonitorId);
            new AdministrativeError(initAdminMonitorId, "Failed to initialize Kubernetes secret provider", "Credentials from Kubernetes Secrets will not be available.", (Throwable)kex);
        }
        catch (LabelSelectorParseException lex) {
            LOG.log(Level.SEVERE, "Failed to initialise k8s secret provider, secrets from Kubernetes will not be available", lex);
            this.clearAdminMonitors(labelSelectorAdminMonitorId);
            new AdministrativeError(labelSelectorAdminMonitorId, "Failed to parse Kubernetes secret label selector", "Failed to parse Kubernetes secret <a href=\"https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors\" _target=\"blank\">label selector</a> expression \"<code>" + labelSelector + "</code>\". Secrets from Kubernetes will not be available. ", (Throwable)lex);
        }
    }

    private void reconnectLater() {
        LOG.log(Level.INFO, "Attempting to reconnect Kubernetes client in {0} mins", this.reconnectClientDelayMins);
        Timer.get().schedule((Runnable)new SafeTimerTask(){

            protected void doRun() throws Exception {
                KubernetesCredentialProvider.this.startWatchingForSecrets();
            }
        }, (long)this.reconnectClientDelayMins, TimeUnit.MINUTES);
    }

    private void clearAdminMonitors(String ... ids) {
        List<String> monitorIds = Arrays.asList(ids);
        ExtensionList all = AdministrativeMonitor.all();
        List toRemove = all.stream().filter(am -> monitorIds.contains(am.id)).collect(Collectors.toList());
        all.removeAll(toRemove);
    }

    @Terminator(after=TermMilestone.STARTED)
    @Restricted(value={NoExternalUse.class})
    public void stopWatchingForSecrets() {
        if (this.watch != null) {
            this.watch.close();
            this.watch = null;
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public <C extends Credentials> List<C> getCredentials(Class<C> type, ItemGroup itemGroup, Authentication authentication) {
        LOG.log(Level.FINEST, "getCredentials called with type {0}, itemgroup {1} and authentication {2}", new Object[]{type.getName(), itemGroup, authentication});
        if (ACL.SYSTEM.equals((Object)authentication)) {
            ArrayList<Credentials> list = new ArrayList<Credentials>();
            for (KubernetesSourcedCredential credential : this.credentials.values()) {
                if (itemGroup == null && !credential.getItemGroups().isEmpty()) continue;
                if (itemGroup != null) {
                    String itemGroupPath = itemGroup.getFullName();
                    Set<String> itemGroups = credential.getItemGroups();
                    LOG.log(Level.FINEST, "getCredentials checking if itemGroupPath {0} is in itemGroups of {1} ({2})", new Object[]{itemGroupPath, credential.getId(), itemGroups});
                    if (!itemGroups.isEmpty()) {
                        if (itemGroups.stream().noneMatch(itemGroupPath::equals)) {
                            LOG.log(Level.FINEST, "getCredentials itemGroupPath not found in: {0}", itemGroups);
                            continue;
                        }
                    }
                }
                LOG.log(Level.FINEST, "getCredentials {0} is a possible candidate", credential.getId());
                if (CredentialsScope.SYSTEM == credential.getScope() && !(itemGroup instanceof Jenkins)) {
                    LOG.log(Level.FINEST, "getCredentials {0} has SYSTEM scope, but the context is not Jenkins, ignoring", credential.getId());
                    continue;
                }
                if (type.isAssignableFrom(credential.getIdCredentials().getClass())) {
                    LOG.log(Level.FINEST, "getCredentials {0} matches, adding to list", credential.getId());
                    list.add((Credentials)type.cast(credential.getIdCredentials()));
                    continue;
                }
                LOG.log(Level.FINEST, "getCredentials {0} does not match", credential.getId());
            }
            return list;
        }
        return this.emptyList();
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, Authentication authentication) {
        return this.getCredentials(type, item.getParent(), authentication);
    }

    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, Authentication authentication, List<DomainRequirement> domainRequirements) {
        return this.getCredentials(type, item, authentication);
    }

    @NonNull
    private final <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    private void addSecret(Secret secret) {
        this.addSecret(secret, this.credentials);
    }

    private void addSecret(Secret secret, Map<String, KubernetesSourcedCredential> map) {
        KubernetesSourcedCredential cred = this.convertSecret(secret);
        String credentialId = SecretUtils.getCredentialId(secret);
        if (cred != null) {
            map.put(credentialId, cred);
        }
    }

    public void eventReceived(Watcher.Action action, Secret secret) {
        String credentialId = SecretUtils.getCredentialId(secret);
        switch (action) {
            case ADDED: {
                LOG.log(Level.FINE, "Secret Added - {0}", credentialId);
                this.addSecret(secret);
                break;
            }
            case MODIFIED: {
                LOG.log(Level.FINE, "Secret Modified - {0}", credentialId);
                this.addSecret(secret);
                break;
            }
            case DELETED: {
                LOG.log(Level.FINE, "Secret Deleted - {0}", credentialId);
                this.credentials.remove(credentialId);
                break;
            }
            case ERROR: {
                LOG.log(Level.WARNING, "Action received of type Error. {0}", secret);
                break;
            }
        }
    }

    public void onClose(WatcherException cause) {
        if (cause != null) {
            LOG.log(Level.WARNING, "Secrets watch stopped unexpectedly", (Throwable)cause);
            LOG.log(Level.INFO, "Restating secrets watcher");
            this.startWatchingForSecrets();
        } else {
            LOG.log(Level.INFO, "Secrets watcher stopped");
        }
    }

    @CheckForNull
    KubernetesSourcedCredential convertSecret(Secret s) {
        String type = (String)s.getMetadata().getLabels().get("jenkins.io/credentials-type");
        SecretToCredentialConverter lookup = SecretToCredentialConverter.lookup(type);
        if (lookup != null) {
            try {
                return new KubernetesSourcedCredential(lookup.convert(s), SecretUtils.getCredentialItemScopes(s));
            }
            catch (CredentialsConvertionException ex) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Failed to convert Secret '" + SecretUtils.getCredentialId(s) + "' of type " + type, ex);
                } else {
                    LOG.log(Level.WARNING, "Failed to convert Secret ''{0}'' of type {1} due to {2}", new Object[]{SecretUtils.getCredentialId(s), type, ex.getMessage()});
                }
                return null;
            }
        }
        LOG.log(Level.WARNING, "No SecretToCredentialConverter found to convert secrets of type {0}", type);
        return null;
    }

    public CredentialsStore getStore(ModelObject object) {
        if (object instanceof ItemGroup) {
            this.lazyStoreCache.putIfAbsent(object, new KubernetesCredentialsStore(this, (ItemGroup)object));
            return this.lazyStoreCache.get(object);
        }
        return null;
    }

    public String getIconClassName() {
        return "symbol-kubernetes plugin-kubernetes-credentials-provider";
    }
}

