/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.convertors;

import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.CredentialsConvertionException;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretToCredentialConverter;
import com.cloudbees.jenkins.plugins.kubernetes_credentials_provider.SecretUtils;
import hudson.util.Secret;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"docker-commons"})
public class DockerServerCredentialsConvertor
extends SecretToCredentialConverter {
    @Override
    public boolean canConvert(String type) {
        return "x509ClientCert".equals(type);
    }

    public DockerServerCredentials convert(io.fabric8.kubernetes.api.model.Secret secret) throws CredentialsConvertionException {
        SecretUtils.requireNonNull(secret.getData(), "X.509 client certificate definition contains no data");
        String clientCertificateBase64 = SecretUtils.getNonNullSecretData(secret, "clientCertificate", "X.509 client certificate is missing the clientCertificate entry");
        String clientCertificate = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(clientCertificateBase64), "X.509 client certificate has an invalid clientCertificate entry (must be base64 encoded UTF-8)");
        String clientKeySecretBase64 = SecretUtils.getNonNullSecretData(secret, "clientKeySecret", "X.509 client certificate is missing the clientKeySecret entry");
        String clientKeySecret = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(clientKeySecretBase64), "X.509 client certificate has an invalid clientKeySecret entry (must be base64 encoded UTF-8)");
        String serverCaCertificateBase64 = SecretUtils.getNonNullSecretData(secret, "serverCaCertificate", "X.509 client certificate is missing the serverCaCertificate entry");
        String serverCaCertificate = SecretUtils.requireNonNull(SecretUtils.base64DecodeToString(serverCaCertificateBase64), "X.509 client certificate has an invalid serverCaCertificate entry (must be base64 encoded UTF-8)");
        return new DockerServerCredentials(SecretUtils.getCredentialScope(secret), SecretUtils.getCredentialId(secret), SecretUtils.getCredentialDescription(secret), Secret.fromString((String)clientKeySecret), clientCertificate, serverCaCertificate);
    }
}

